/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECPrivateKeySpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECPublicKeySpec;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.FixedSecureRandom;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class ImplicitlyCaTest
extends SimpleTest {
    byte[] k1 = Hex.decode("d5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    byte[] k2 = Hex.decode("345e8d05c075c3a508df729a1685690e68fcfb8c8117847e89063bca1f85d968fd281540b6e13bd1af989a1fbf17e06462bf511f9d0b140fb48ac1b1baa5bded");
    SecureRandom random = new FixedSecureRandom(new byte[][]{this.k1, this.k2});

    public void performTest() throws Exception {
        KeyPairGenerator g = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec ecSpec = new ECParameterSpec(curve, curve.decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        ConfigurableProvider config = (ConfigurableProvider)((Object)Security.getProvider("BC"));
        config.setParameter("ecImplicitlyCa", ecSpec);
        g.initialize(null, new SecureRandom());
        KeyPair p = g.generateKeyPair();
        ECPrivateKey sKey = (ECPrivateKey)p.getPrivate();
        ECPublicKey vKey = (ECPublicKey)p.getPublic();
        this.testECDSA(sKey, vKey);
        this.testBCParamsAndQ(sKey, vKey);
        this.testEncoding(sKey, vKey);
        this.testKeyFactory();
    }

    private void testKeyFactory() throws Exception {
        KeyPairGenerator g = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECCurve.Fp curve = new ECCurve.Fp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839"), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        ECParameterSpec ecSpec = new ECParameterSpec(curve, curve.decodePoint(Hex.decode("020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"));
        ConfigurableProvider config = (ConfigurableProvider)((Object)Security.getProvider("BC"));
        config.setParameter("ecImplicitlyCa", ecSpec);
        g.initialize(null, new SecureRandom());
        KeyPair p = g.generateKeyPair();
        ECPrivateKey sKey = (ECPrivateKey)p.getPrivate();
        ECPublicKey vKey = (ECPublicKey)p.getPublic();
        KeyFactory fact = KeyFactory.getInstance("ECDSA", "BC");
        vKey = (ECPublicKey)fact.generatePublic(new ECPublicKeySpec(vKey.getQ(), null));
        sKey = (ECPrivateKey)fact.generatePrivate(new ECPrivateKeySpec(sKey.getD(), null));
        this.testECDSA(sKey, vKey);
        this.testBCParamsAndQ(sKey, vKey);
        this.testEncoding(sKey, vKey);
        ECPublicKey vKey2 = (ECPublicKey)fact.generatePublic(new ECPublicKeySpec(vKey.getQ(), ecSpec));
        ECPrivateKey sKey2 = (ECPrivateKey)fact.generatePrivate(new ECPrivateKeySpec(sKey.getD(), ecSpec));
        if (!vKey.equals(vKey2) || vKey.hashCode() != vKey2.hashCode()) {
            this.fail("private equals/hashCode failed");
        }
        if (!sKey.equals(sKey2) || sKey.hashCode() != sKey2.hashCode()) {
            this.fail("private equals/hashCode failed");
        }
    }

    private void testECDSA(ECPrivateKey sKey, ECPublicKey vKey) throws Exception {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        Signature s = Signature.getInstance("ECDSA", "BC");
        s.initSign(sKey);
        s.update(data);
        byte[] sigBytes = s.sign();
        s = Signature.getInstance("ECDSA", "BC");
        s.initVerify(vKey);
        s.update(data);
        if (!s.verify(sigBytes)) {
            this.fail("ECDSA verification failed");
        }
    }

    private void testEncoding(ECPrivateKey privKey, ECPublicKey pubKey) throws Exception {
        ECPublicKey vKey;
        SubjectPublicKeyInfo vInfo;
        ECPrivateKey sKey;
        KeyFactory kFact = KeyFactory.getInstance("ECDSA", "BC");
        byte[] bytes = privKey.getEncoded();
        PrivateKeyInfo sInfo = PrivateKeyInfo.getInstance(new ASN1InputStream(bytes).readObject());
        if (!sInfo.getAlgorithmId().getParameters().equals(DERNull.INSTANCE)) {
            this.fail("private key parameters wrong");
        }
        if (!(sKey = (ECPrivateKey)kFact.generatePrivate(new PKCS8EncodedKeySpec(bytes))).equals(privKey)) {
            this.fail("private equals failed");
        }
        if (sKey.hashCode() != privKey.hashCode()) {
            this.fail("private hashCode failed");
        }
        if (!(vInfo = SubjectPublicKeyInfo.getInstance(new ASN1InputStream(bytes = pubKey.getEncoded()).readObject())).getAlgorithmId().getParameters().equals(DERNull.INSTANCE)) {
            this.fail("public key parameters wrong");
        }
        if (!(vKey = (ECPublicKey)kFact.generatePublic(new X509EncodedKeySpec(bytes))).equals(pubKey) || vKey.hashCode() != pubKey.hashCode()) {
            this.fail("public equals/hashCode failed");
        }
        this.testBCParamsAndQ(sKey, vKey);
        this.testECDSA(sKey, vKey);
    }

    private void testBCParamsAndQ(ECPrivateKey sKey, ECPublicKey vKey) {
        if (sKey.getParameters() != null) {
            this.fail("parameters exposed in private key");
        }
        if (vKey.getParameters() != null) {
            this.fail("parameters exposed in public key");
        }
        if (vKey.getQ().getCurve() != null) {
            this.fail("curve exposed in public point");
        }
    }

    public String getName() {
        return "ImplicitlyCA";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        ImplicitlyCaTest.runTest(new ImplicitlyCaTest());
    }
}

