/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.pkcs.jcajce;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import cfca.sadk.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import cfca.sadk.org.bouncycastle.jcajce.io.MacOutputStream;
import cfca.sadk.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import cfca.sadk.org.bouncycastle.jcajce.util.JcaJceHelper;
import cfca.sadk.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import cfca.sadk.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import cfca.sadk.org.bouncycastle.operator.GenericKey;
import cfca.sadk.org.bouncycastle.operator.MacCalculator;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class JcePKCS12MacCalculatorBuilder
implements PKCS12MacCalculatorBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private ExtendedDigest digest;
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;
    private int saltLength;
    private int iterationCount = 1024;

    public JcePKCS12MacCalculatorBuilder() {
        this(OIWObjectIdentifiers.idSHA1);
    }

    public JcePKCS12MacCalculatorBuilder(ASN1ObjectIdentifier hashAlgorithm) {
        this.algorithm = hashAlgorithm;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return new AlgorithmIdentifier(this.algorithm, DERNull.INSTANCE);
    }

    public MacCalculator build(final char[] password) throws OperatorCreationException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            final Mac mac = this.helper.createMac(this.algorithm.getId());
            this.saltLength = mac.getMacLength();
            final byte[] salt = new byte[this.saltLength];
            this.random.nextBytes(salt);
            SecretKeyFactory keyFact = this.helper.createSecretKeyFactory(this.algorithm.getId());
            PBEParameterSpec defParams = new PBEParameterSpec(salt, this.iterationCount);
            PBEKeySpec pbeSpec = new PBEKeySpec(password);
            SecretKey key = keyFact.generateSecret(pbeSpec);
            mac.init(key, defParams);
            return new MacCalculator(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return new AlgorithmIdentifier(JcePKCS12MacCalculatorBuilder.this.algorithm, new PKCS12PBEParams(salt, JcePKCS12MacCalculatorBuilder.this.iterationCount));
                }

                public OutputStream getOutputStream() {
                    return new MacOutputStream(mac);
                }

                public byte[] getMac() {
                    return mac.doFinal();
                }

                public GenericKey getKey() {
                    return new GenericKey(this.getAlgorithmIdentifier(), PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
                }
            };
        }
        catch (Exception e) {
            throw new OperatorCreationException("unable to create MAC calculator: " + e.getMessage(), e);
        }
    }
}

