/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.pqc.crypto.test;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA224Digest;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.sadk.org.bouncycastle.pqc.crypto.DigestingMessageSigner;
import cfca.sadk.org.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import cfca.sadk.org.bouncycastle.pqc.crypto.gmss.GMSSKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.pqc.crypto.gmss.GMSSKeyPairGenerator;
import cfca.sadk.org.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import cfca.sadk.org.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.pqc.crypto.gmss.GMSSSigner;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.FixedSecureRandom;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GMSSSignerTest
extends SimpleTest {
    byte[] keyData = Hex.decode("b5014e4b60ef2ba8b6211b4062ba3224e0427dd3");
    SecureRandom keyRandom = new FixedSecureRandom(new byte[][]{this.keyData, this.keyData});

    public String getName() {
        return "GMSS";
    }

    public void performTest() throws Exception {
        GMSSParameters params = new GMSSParameters(3, new int[]{15, 15, 10}, new int[]{5, 5, 4}, new int[]{3, 3, 2});
        GMSSDigestProvider digProvider = new GMSSDigestProvider(){

            public Digest get() {
                return new SHA224Digest();
            }
        };
        GMSSKeyPairGenerator gmssKeyGen = new GMSSKeyPairGenerator(digProvider);
        GMSSKeyGenerationParameters genParam = new GMSSKeyGenerationParameters(this.keyRandom, params);
        gmssKeyGen.init(genParam);
        AsymmetricCipherKeyPair pair = gmssKeyGen.generateKeyPair();
        ParametersWithRandom param = new ParametersWithRandom(pair.getPrivate(), this.keyRandom);
        DigestingMessageSigner gmssSigner = new DigestingMessageSigner(new GMSSSigner(digProvider), new SHA224Digest());
        gmssSigner.init(true, param);
        byte[] message = BigIntegers.asUnsignedByteArray(new BigInteger("968236873715988614170569073515315707566766479517"));
        gmssSigner.update(message, 0, message.length);
        byte[] sig = gmssSigner.generateSignature();
        gmssSigner.init(false, pair.getPublic());
        gmssSigner.update(message, 0, message.length);
        if (!gmssSigner.verifySignature(sig)) {
            this.fail("verification fails");
        }
        if (!((GMSSPrivateKeyParameters)pair.getPrivate()).isUsed()) {
            this.fail("private key not marked as used");
        }
    }

    public static void main(String[] args) {
        GMSSSignerTest.runTest(new GMSSSignerTest());
    }
}

