/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.tsp.test;

import cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import cfca.sadk.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.cms.CMSTimeStampedData;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import junit.framework.TestCase;

public class CMSTimeStampedDataTest
extends TestCase {
    CMSTimeStampedData cmsTimeStampedData = null;
    String fileInput = "FileDaFirmare.txt.tsd.der";
    String fileOutput = this.fileInput.substring(0, this.fileInput.indexOf(".tsd"));
    private byte[] baseData;

    protected void setUp() throws Exception {
        int ch;
        ByteArrayOutputStream origStream = new ByteArrayOutputStream();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.fileInput);
        while ((ch = in.read()) >= 0) {
            origStream.write(ch);
        }
        origStream.close();
        this.baseData = origStream.toByteArray();
        this.cmsTimeStampedData = new CMSTimeStampedData(this.baseData);
    }

    protected void tearDown() throws Exception {
        this.cmsTimeStampedData = null;
    }

    public void testGetTimeStampTokens() throws Exception {
        TimeStampToken[] tokens = this.cmsTimeStampedData.getTimeStampTokens();
        CMSTimeStampedDataTest.assertEquals((int)3, (int)tokens.length);
    }

    public void testValidateAllTokens() throws Exception {
        BcDigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
        DigestCalculator imprintCalculator = this.cmsTimeStampedData.getMessageImprintDigestCalculator(digestCalculatorProvider);
        imprintCalculator.getOutputStream().write(this.cmsTimeStampedData.getContent());
        byte[] digest = imprintCalculator.getDigest();
        TimeStampToken[] tokens = this.cmsTimeStampedData.getTimeStampTokens();
        for (int i = 0; i < tokens.length; ++i) {
            this.cmsTimeStampedData.validate(digestCalculatorProvider, digest, tokens[i]);
        }
    }

    public void testValidate() throws Exception {
        BcDigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
        DigestCalculator imprintCalculator = this.cmsTimeStampedData.getMessageImprintDigestCalculator(digestCalculatorProvider);
        imprintCalculator.getOutputStream().write(this.cmsTimeStampedData.getContent());
        this.cmsTimeStampedData.validate(digestCalculatorProvider, imprintCalculator.getDigest());
    }
}

