/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.FileUtil;
import cfca.sadk.algorithm.util.InitKeyStore;
import cfca.sadk.algorithm.util.P7BParser;
import cfca.sadk.algorithm.util.SM2OIDUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.BasicConstraints;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;

public class CertUtil {
    public static byte[] getCertExtensionData(X509Cert x509Cert, String oid) throws PKIException {
        try {
            byte[] extension = x509Cert.getExtensionByteData(new ASN1ObjectIdentifier(oid));
            if (extension == null) {
                return null;
            }
            byte b = extension[1];
            int blen = b & 0x80;
            if (blen == 0) {
                byte[] ret = new byte[extension.length - 2];
                System.arraycopy(extension, 2, ret, 0, extension.length - 2);
                return ret;
            }
            blen = b & 0x7F;
            byte[] ret = new byte[extension.length - 2 - blen];
            System.arraycopy(extension, 2 + blen, ret, 0, extension.length - 2 - blen);
            return ret;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static Extensions getCertExtensionsData(X509Cert x509Cert) {
        return x509Cert.getExtensionsData();
    }

    public static X509Cert getCertFromSM2(String sm2FilePath) throws PKIException {
        FilterInputStream asn1InputStream = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sm2FilePath);
            byte[] data = new byte[fis.available()];
            fis.read(data);
            boolean isB64 = ASN1Parser.isBase64Compatability(data);
            if (isB64) {
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            asn1InputStream = new ASN1InputStream(bis);
            PKCS12_SM2 sm2FileParser = PKCS12_SM2.getInstance(((ASN1InputStream)asn1InputStream).readObject());
            X509Cert x509Cert = sm2FileParser.getPublicCert()[0];
            return x509Cert;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static X509Cert getCertFromSM2(InputStream inputStream) throws PKIException {
        FilterInputStream asn1InputStream = null;
        try {
            byte[] data = new byte[inputStream.available()];
            inputStream.read(data);
            boolean isB64 = ASN1Parser.isBase64Compatability(data);
            if (isB64) {
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            asn1InputStream = new ASN1InputStream(bis);
            PKCS12_SM2 object = PKCS12_SM2.getInstance(((ASN1InputStream)asn1InputStream).readObject());
            X509Cert x509Cert = object.getPublicCert()[0];
            return x509Cert;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static X509Cert getCertFromSM2(byte[] data) throws PKIException {
        FilterInputStream asn1InputStream = null;
        try {
            boolean isB64 = ASN1Parser.isBase64Compatability(data);
            if (isB64) {
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            asn1InputStream = new ASN1InputStream(bis);
            PKCS12_SM2 object = PKCS12_SM2.getInstance(((ASN1InputStream)asn1InputStream).readObject());
            X509Cert x509Cert = object.getPublicCert()[0];
            return x509Cert;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static X509Cert getCertFromPFX(String pfxFilePath, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxFilePath);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getCerts()[0];
    }

    public static X509Cert getCertFromPFX(InputStream is, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(is);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getCerts()[0];
    }

    public static X509Cert getCertFromPFX(byte[] pfxFileData, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxFileData);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getCerts()[0];
    }

    public static X509Cert getCertFromJKS(String jksFilePath, String jksFilePwd, String alias) throws PKIException {
        try {
            KeyStore keyStore = InitKeyStore.initJKSKeyStore(jksFilePath, jksFilePwd);
            Certificate certificate = keyStore.getCertificate(alias);
            if (certificate != null) {
                return new X509Cert(certificate.getEncoded());
            }
            throw new PKIException("no such alias cert!");
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static X509Cert[] parseP7B(String p7bFilePath) throws PKIException {
        try {
            return P7BParser.parseP7B(FileUtil.getBytesFromFile(p7bFilePath));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static X509Cert[] parseP7B(byte[] p7bData) throws PKIException {
        try {
            return P7BParser.parseP7B(p7bData);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void generateP7BFile(X509Cert[] certs, String saveFilePath) throws PKIException {
        try {
            P7BParser.generateP7BFile(certs, saveFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void generateP7BFile(X509Cert[] certs, OutputStream os) throws PKIException {
        try {
            P7BParser.generateP7BFile(certs, os);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] generateP7BData(X509Cert[] certs) throws PKIException {
        try {
            byte[] b64Data = P7BParser.generateP7BData(certs);
            return b64Data;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static boolean isSM2Cert(X509Cert x509Cert) {
        return SM2OIDUtil.isSm3WithSM2Encryption(x509Cert.getCertStructure().getSignatureAlgorithm().getAlgorithm());
    }

    public static boolean isCACert(X509Cert x509Cert) throws PKIException {
        boolean isCA = false;
        BasicConstraints bcs = x509Cert.getBasicConstraints();
        if (bcs != null) {
            isCA = bcs.isCA();
        }
        return isCA;
    }
}

