/*
 * Decompiled with CFR 0.152.
 */
package com.rome.sign.httpclient;

import com.rome.sign.core.SignConstant;
import com.rome.sign.httpclient.RSA2ExecChain;
import java.security.PrivateKey;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;

public class RSA2HttpClientBuilder
extends HttpClientBuilder {
    private String clientId;
    private PrivateKey privateKey;

    private RSA2HttpClientBuilder() {
        String userAgent = String.format("LYF-RSA2-Apache-HttpClient/%s (%s) Java/%s", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), SignConstant.OS, SignConstant.VERSION == null ? "Unknown" : SignConstant.VERSION);
        this.setUserAgent(userAgent);
    }

    public static RSA2HttpClientBuilder create() {
        return new RSA2HttpClientBuilder();
    }

    public RSA2HttpClientBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public RSA2HttpClientBuilder privateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public CloseableHttpClient build() {
        if (this.clientId == null || "".equals(this.clientId)) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u5546\u6237\u53f7\uff01");
        }
        if (this.privateKey == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u5546\u6237\u79c1\u94a5\uff01");
        }
        return super.build();
    }

    protected ClientExecChain decorateProtocolExec(ClientExecChain requestExecutor) {
        return new RSA2ExecChain(this.clientId, this.privateKey, requestExecutor);
    }
}

