/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlitripTravelHotelticketOrderCreateResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlitripTravelHotelticketOrderCreateRequest
extends BaseTaobaoRequest<AlitripTravelHotelticketOrderCreateResponse> {
    private String extendParams;
    private String failMsg;
    private String fliggyOrderId;
    private String orderId;
    private Long status;
    private String vouchers;

    public void setExtendParams(String extendParams) {
        this.extendParams = extendParams;
    }

    public void setExtendParamsString(String extendParams) {
        this.extendParams = extendParams;
    }

    public String getExtendParams() {
        return this.extendParams;
    }

    public void setFailMsg(String failMsg) {
        this.failMsg = failMsg;
    }

    public String getFailMsg() {
        return this.failMsg;
    }

    public void setFliggyOrderId(String fliggyOrderId) {
        this.fliggyOrderId = fliggyOrderId;
    }

    public String getFliggyOrderId() {
        return this.fliggyOrderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public Long getStatus() {
        return this.status;
    }

    public void setVouchers(String vouchers) {
        this.vouchers = vouchers;
    }

    public void setVouchers(List<HotelTicketVoucherDTO> vouchers) {
        this.vouchers = new JSONWriter(false, true).write(vouchers);
    }

    public String getVouchers() {
        return this.vouchers;
    }

    @Override
    public String getApiMethodName() {
        return "alitrip.travel.hotelticket.order.create";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("extend_params", this.extendParams);
        txtParams.put("fail_msg", this.failMsg);
        txtParams.put("fliggy_order_id", this.fliggyOrderId);
        txtParams.put("order_id", this.orderId);
        txtParams.put("status", (Object)this.status);
        txtParams.put("vouchers", this.vouchers);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<AlitripTravelHotelticketOrderCreateResponse> getResponseClass() {
        return AlitripTravelHotelticketOrderCreateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.fliggyOrderId, "fliggyOrderId");
        RequestCheckUtils.checkNotEmpty(this.status, "status");
    }

    public static class HotelTicketVoucherDTO
    extends TaobaoObject {
        private static final long serialVersionUID = 6645288619227488384L;
        @ApiField(value="available_nums")
        private Long availableNums;
        @ApiField(value="biz_type")
        private Long bizType;
        @ApiField(value="can_use")
        private Boolean canUse;
        @ApiField(value="certificate_id")
        private String certificateId;
        @ApiField(value="code")
        private String code;
        @ApiField(value="type")
        private Long type;
        @ApiField(value="url")
        private String url;
        @ApiField(value="usage_nums")
        private Long usageNums;

        public Long getAvailableNums() {
            return this.availableNums;
        }

        public void setAvailableNums(Long availableNums) {
            this.availableNums = availableNums;
        }

        public Long getBizType() {
            return this.bizType;
        }

        public void setBizType(Long bizType) {
            this.bizType = bizType;
        }

        public Boolean getCanUse() {
            return this.canUse;
        }

        public void setCanUse(Boolean canUse) {
            this.canUse = canUse;
        }

        public String getCertificateId() {
            return this.certificateId;
        }

        public void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public Long getType() {
            return this.type;
        }

        public void setType(Long type) {
            this.type = type;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Long getUsageNums() {
            return this.usageNums;
        }

        public void setUsageNums(Long usageNums) {
            this.usageNums = usageNums;
        }
    }
}

