/*
 * Decompiled with CFR 0.152.
 */
package api;

import api.ApiResponse;
import api.DigestUtils;
import api.SHA1;
import api.SM2Cryptor;
import api.SM2Sign;
import api.SM2SignVerify;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SPDBSMEncryptor {
    private static final String contentType = "application/json;charset=utf-8";
    private static final String charset = "UTF-8";
    private static final OkHttpClient client = new OkHttpClient.Builder().connectionPool(new ConnectionPool(500, 5L, TimeUnit.MINUTES)).connectTimeout(10000L, TimeUnit.MILLISECONDS).readTimeout(60000L, TimeUnit.MILLISECONDS).build();

    public static Request createRequest(String requestMethod, String url, String data, String signature, String clientId, Boolean forbidden, long timestamp, String nonce, Boolean encryption) {
        Request request = null;
        if ("GET".equals(requestMethod) || "get".equals(requestMethod)) {
            url = encryption != false ? url + "?encryptBody=" + data : url + "?" + data;
            Request.Builder builder = new Request.Builder().url(url).get().addHeader("Content-Type", contentType).addHeader("X-SPDB-Client-ID", clientId).addHeader("X-SPDB-SIGNATURE", signature).addHeader("X-SPDB-SM", "true");
            request = SPDBSMEncryptor.getRequest(forbidden, timestamp, nonce, encryption, builder);
        } else if ("POST".equals(requestMethod) || "post".equals(requestMethod)) {
            MediaType mediaType = MediaType.parse((String)contentType);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)data);
            Request.Builder builder = new Request.Builder().url(url).post(body).addHeader("Content-Type", contentType).addHeader("X-SPDB-Client-ID", clientId).addHeader("X-SPDB-SIGNATURE", signature).addHeader("X-SPDB-SM", "true");
            request = SPDBSMEncryptor.getRequest(forbidden, timestamp, nonce, encryption, builder);
        } else if ("PUT".equals(requestMethod) || "put".equals(requestMethod)) {
            MediaType mediaType = MediaType.parse((String)contentType);
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)data);
            Request.Builder builder = new Request.Builder().url(url).put(body).addHeader("Content-Type", contentType).addHeader("X-SPDB-Client-ID", clientId).addHeader("X-SPDB-SIGNATURE", signature).addHeader("X-SPDB-SM", "true");
            request = SPDBSMEncryptor.getRequest(forbidden, timestamp, nonce, encryption, builder);
        }
        return request;
    }

    private static Request getRequest(Boolean forbidden, long timestamp, String nonce, Boolean encryption, Request.Builder builder) {
        Request request = encryption.booleanValue() ? (forbidden.booleanValue() ? builder.addHeader("X-SPDB-Encryption", "true").addHeader("X-SPDB-Timestamp", String.valueOf(timestamp)).addHeader("X-SPDB-Nonce", nonce).build() : builder.addHeader("X-SPDB-Encryption", "true").build()) : (forbidden != false ? builder.addHeader("X-SPDB-Timestamp", String.valueOf(timestamp)).addHeader("X-SPDB-Nonce", nonce).build() : builder.build());
        return request;
    }

    public static ApiResponse requestApi(String clientId, String secret, String privatekey, String spdb_publicKey, String method, String url, String data, Boolean forbidden, Boolean encryption) throws Exception {
        long timestamp = 0L;
        String newBodyData = data;
        String nonce = "";
        if (forbidden.booleanValue()) {
            long num = Math.round((Math.random() + 0.1) * 1.0E8);
            nonce = Long.toString(num);
            if (Long.toString(num).length() == 7) {
                nonce = Long.toString(num * 10L);
            } else if (Long.toString(num).length() == 9) {
                nonce = Long.toString(num).substring(0, 8);
            }
            nonce = "TRANS" + nonce;
            timestamp = System.currentTimeMillis();
            newBodyData = data + timestamp + nonce;
        }
        String signature = "";
        if (encryption.booleanValue()) {
            data = SM2Cryptor.encrypt(secret, data);
            byte[] dataBytes = newBodyData.getBytes(charset);
            SM2Sign sign = SM2SignVerify.sign(ByteUtils.fromHexString((String)privatekey), dataBytes);
            byte[] signBytes = sign.getSm2_sign().getBytes(charset);
            signature = DatatypeConverter.printBase64Binary((byte[])signBytes);
        } else {
            signature = DigestUtils.sign(secret, newBodyData);
        }
        ApiResponse apiResponse = new ApiResponse();
        Request request = SPDBSMEncryptor.createRequest(method, url, data, signature, clientId, forbidden, timestamp, nonce, encryption);
        Response response = client.newCall(request).execute();
        apiResponse.setCode(response.code());
        String resBody = new String(response.body().bytes(), charset);
        apiResponse.setBody(resBody);
        apiResponse.setHeaders(response.headers());
        String decryptBody = resBody;
        if (encryption.booleanValue()) {
            decryptBody = SM2Cryptor.decrypt(secret, resBody);
            apiResponse.setDecryptBody(decryptBody);
        }
        if (!StringUtils.isEmpty((CharSequence)response.header("X-SPDB-SIGNATURE"))) {
            String sg = new String(response.header("X-SPDB-SIGNATURE").getBytes(), charset);
            String digest = SHA1.digest(decryptBody);
            byte[] bytes = digest.getBytes(charset);
            byte[] signatureBytes = ByteUtils.fromHexString((String)new String(DatatypeConverter.parseBase64Binary((String)sg)));
            SM2Sign sm2Sign = SM2SignVerify.validateSign(ByteUtils.fromHexString((String)spdb_publicKey), bytes, signatureBytes);
            boolean validateSign = sm2Sign.isVerify();
            apiResponse.setVerify(validateSign);
        }
        return apiResponse;
    }
}

