/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.ops.servergroup;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesApiConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesClientApiConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.KubernetesServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.KubernetesUtil;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.autoscaler.KubernetesAutoscalerDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.servergroup.DeployKubernetesAtomicOperationDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesClientOperationException;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesOperationException;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.security.KubernetesV1Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DoneableDeployment;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.kubernetes.client.models.V1Pod;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class DeployKubernetesAtomicOperation
implements AtomicOperation<DeploymentResult>,
GroovyObject {
    private static final String BASE_PHASE = "DEPLOY";
    private final DeployKubernetesAtomicOperationDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public DeployKubernetesAtomicOperation(DeployKubernetesAtomicOperationDescription deployKubernetesAtomicOperationDescription) {
        void description;
        MetaClass metaClass;
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var4_4 = description;
        this.description = (DeployKubernetesAtomicOperationDescription)ScriptBytecodeAdapter.castToType((Object)var4_4, DeployKubernetesAtomicOperationDescription.class);
    }

    private static Task getTask() {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(TaskRepository.class)), Task.class);
    }

    public DeploymentResult operate(List priorOutputs) {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        HasMetadata serverGroup = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[2].callCurrent((GroovyObject)this);
            serverGroup = (HasMetadata)ScriptBytecodeAdapter.castToType((Object)object, HasMetadata.class);
        } else {
            HasMetadata hasMetadata;
            serverGroup = hasMetadata = this.deployDescription();
        }
        DeploymentResult deploymentResult = (DeploymentResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(DeploymentResult.class), DeploymentResult.class);
        Object object = callSiteArray[4].call(Arrays.class, callSiteArray[5].call((Object)new GStringImpl(new Object[]{callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty((Object)serverGroup)), callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty((Object)serverGroup))}, new String[]{"", ":", ""})));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DeployKubernetesAtomicOperation.class, (GroovyObject)deploymentResult, (String)"serverGroupNames");
        Object object2 = callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty((Object)serverGroup));
        callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)deploymentResult), callSiteArray[14].callGetProperty(callSiteArray[15].callGetProperty((Object)serverGroup)), object2);
        return deploymentResult;
    }

    public HasMetadata deployDescription() {
        Object object;
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Initializing creation of replica set.");
        callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Looking up provided namespace...");
        Object credentials = callSiteArray[20].callGetProperty(callSiteArray[21].callGroovyObjectGetProperty((Object)this.description));
        Object namespaceToValidate = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callGetPropertySafe(callSiteArray[23].callGroovyObjectGetProperty((Object)this.description)))) {
            Object object2;
            namespaceToValidate = object2 = callSiteArray[24].callGetProperty(callSiteArray[25].callGroovyObjectGetProperty((Object)this.description));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].callGroovyObjectGetProperty((Object)this.description))) {
            Object object3;
            namespaceToValidate = object3 = callSiteArray[27].callGroovyObjectGetProperty((Object)this.description);
        } else {
            String string = "default";
            namespaceToValidate = string;
        }
        Object namespace = callSiteArray[28].call(KubernetesUtil.class, credentials, namespaceToValidate);
        Object object4 = callSiteArray[29].call(callSiteArray[30].callGetProperty(credentials), namespace);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, DeployKubernetesAtomicOperation.class, (GroovyObject)this.description, (String)"imagePullSecrets");
        Object serverGroupNameResolver = callSiteArray[31].callConstructor(KubernetesServerGroupNameResolver.class, namespace, credentials);
        Object clusterName = callSiteArray[32].call(serverGroupNameResolver, callSiteArray[33].callGroovyObjectGetProperty((Object)this.description), callSiteArray[34].callGroovyObjectGetProperty((Object)this.description), callSiteArray[35].callGroovyObjectGetProperty((Object)this.description));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].callGroovyObjectGetProperty((Object)this.description))) {
            Object controllerName = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].callGroovyObjectGetProperty((Object)this.description)) ? callSiteArray[38].call(serverGroupNameResolver, ArrayUtil.createArray((Object)callSiteArray[39].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[40].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[41].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this.description), (Object)false)) : clusterName;
            return (HasMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].callCurrent((GroovyObject)this, credentials, controllerName, clusterName, namespace), HasMetadata.class);
        }
        callSiteArray[44].call(callSiteArray[45].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{clusterName}, new String[]{"Looking up next sequence index for cluster ", "..."}));
        String replicaSetName = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].callGroovyObjectGetProperty((Object)this.description))) {
            Object object5 = callSiteArray[47].call(serverGroupNameResolver, ArrayUtil.createArray((Object)callSiteArray[48].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[49].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[50].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[51].callGroovyObjectGetProperty((Object)this.description), (Object)false));
            replicaSetName = ShortTypeHandling.castToString((Object)object5);
        } else {
            Object object6 = callSiteArray[52].call(serverGroupNameResolver, callSiteArray[53].callGroovyObjectGetProperty((Object)this.description), callSiteArray[54].callGroovyObjectGetProperty((Object)this.description), callSiteArray[55].callGroovyObjectGetProperty((Object)this.description), (Object)false);
            replicaSetName = ShortTypeHandling.castToString((Object)object6);
        }
        callSiteArray[56].call(callSiteArray[57].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{replicaSetName}, new String[]{"Replica set name chosen to be ", "."}));
        Object hasDeployment = callSiteArray[58].call(KubernetesApiConverter.class, (Object)this.description);
        Object replicaSet = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callGetPropertySafe(callSiteArray[60].callGroovyObjectGetProperty((Object)this.description)))) {
            Object object7;
            callSiteArray[61].call(callSiteArray[62].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[63].callGetProperty(callSiteArray[64].callGroovyObjectGetProperty((Object)this.description))}, new String[]{"Searching for ancestor server group ", "..."}));
            Object ancestorServerGroup = callSiteArray[65].call(callSiteArray[66].callGetProperty(credentials), namespace, callSiteArray[67].callGetProperty(callSiteArray[68].callGroovyObjectGetProperty((Object)this.description)));
            if (!DefaultTypeTransformation.booleanUnbox((Object)ancestorServerGroup)) {
                Object object8;
                ancestorServerGroup = object8 = callSiteArray[69].call(callSiteArray[70].callGetProperty(credentials), namespace, callSiteArray[71].callGetProperty(callSiteArray[72].callGroovyObjectGetProperty((Object)this.description)));
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)ancestorServerGroup)) {
                throw (Throwable)callSiteArray[73].callConstructor(KubernetesResourceNotFoundException.class, (Object)new GStringImpl(new Object[]{callSiteArray[74].callGetProperty(callSiteArray[75].callGroovyObjectGetProperty((Object)this.description)), namespace}, new String[]{"Source Server Group: ", " does not exist in Namespace: ", "!"}));
            }
            callSiteArray[76].call(callSiteArray[77].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{ancestorServerGroup}, new String[]{"Ancestor Server Group Located: ", ""}));
            Object object9 = callSiteArray[78].callGetPropertySafe(callSiteArray[79].callGetProperty(ancestorServerGroup));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object9, DeployKubernetesAtomicOperation.class, (GroovyObject)this.description, (String)"targetSize");
            callSiteArray[80].call(callSiteArray[81].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building replica set...");
            replicaSet = object7 = callSiteArray[82].call(KubernetesApiConverter.class, callSiteArray[83].callConstructor(ReplicaSetBuilder.class), (Object)this.description, (Object)replicaSetName);
            if (DefaultTypeTransformation.booleanUnbox((Object)hasDeployment)) {
                int n = 0;
                ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)callSiteArray[84].callGetProperty(replicaSet), (String)"replicas");
            }
        } else {
            Object object10;
            callSiteArray[85].call(callSiteArray[86].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building replica set...");
            replicaSet = object10 = callSiteArray[87].call(KubernetesApiConverter.class, callSiteArray[88].callConstructor(ReplicaSetBuilder.class), (Object)this.description, (Object)replicaSetName);
            if (DefaultTypeTransformation.booleanUnbox((Object)hasDeployment)) {
                int n = 0;
                ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)callSiteArray[89].callGetProperty(replicaSet), (String)"replicas");
            }
        }
        replicaSet = object = callSiteArray[90].call(callSiteArray[91].callGetProperty(credentials), namespace, replicaSet);
        callSiteArray[92].call(callSiteArray[93].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{callSiteArray[94].callGetProperty(callSiteArray[95].callGetProperty(replicaSet))}, new String[]{"Deployed replica set ", ""}));
        if (DefaultTypeTransformation.booleanUnbox((Object)hasDeployment)) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].call(callSiteArray[97].callGetProperty(credentials), namespace, clusterName))) {
                callSiteArray[98].call(callSiteArray[99].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building deployment...");
                callSiteArray[100].call(callSiteArray[101].callGetProperty(credentials), namespace, callSiteArray[102].call((Object)((DeploymentBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].call(KubernetesApiConverter.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((DeploymentFluentImpl)callSiteArray[104].callConstructor(DeploymentBuilder.class)), DeploymentFluentImpl.class), (Object)this.description, (Object)replicaSetName), DeploymentBuilder.class))));
            } else {
                callSiteArray[105].call(callSiteArray[106].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Updating deployment...");
                callSiteArray[107].call((Object)((DoneableDeployment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[108].call(KubernetesApiConverter.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((DeploymentFluentImpl)ScriptBytecodeAdapter.castToType((Object)callSiteArray[109].call(callSiteArray[110].callGetProperty(credentials), namespace, clusterName), DeploymentFluentImpl.class)), DeploymentFluentImpl.class), (Object)this.description, (Object)replicaSetName), DoneableDeployment.class)));
            }
            callSiteArray[111].call(callSiteArray[112].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{clusterName}, new String[]{"Configured deployment ", ""}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[113].callGroovyObjectGetProperty((Object)this.description))) {
            callSiteArray[114].call(callSiteArray[115].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Attaching a horizontal pod autoscaler...");
            Object name = DefaultTypeTransformation.booleanUnbox((Object)hasDeployment) ? clusterName : replicaSetName;
            Object kind = DefaultTypeTransformation.booleanUnbox((Object)hasDeployment) ? callSiteArray[116].callGetProperty(KubernetesUtil.class) : callSiteArray[117].callGetProperty(KubernetesUtil.class);
            Object autoscaler = callSiteArray[118].call(KubernetesApiConverter.class, callSiteArray[119].callConstructor(KubernetesAutoscalerDescription.class, (Object)replicaSetName, (Object)this.description), name, kind);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[120].call(callSiteArray[121].callGetProperty(credentials), namespace, name))) {
                callSiteArray[122].call(callSiteArray[123].callGetProperty(credentials), namespace, name);
            }
            callSiteArray[124].call(callSiteArray[125].callGetProperty(credentials), namespace, autoscaler);
        }
        return (HasMetadata)ScriptBytecodeAdapter.castToType((Object)replicaSet, HasMetadata.class);
    }

    public HasMetadata deployController(KubernetesV1Credentials credentials, String controllerName, String clusterName, String namespace) {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        Object controllerSet = null;
        Object canUpdated = callSiteArray[126].call(KubernetesClientApiConverter.class, (Object)this.description);
        Object object = callSiteArray[127].callGroovyObjectGetProperty((Object)this.description);
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[128].callGetProperty(KubernetesUtil.class))) {
            Object object2;
            controllerSet = object2 = callSiteArray[129].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)credentials, (Object)controllerName, (Object)clusterName, (Object)namespace, (Object)canUpdated));
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[130].callGetProperty(KubernetesUtil.class))) {
            Object object3;
            controllerSet = object3 = callSiteArray[131].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)credentials, (Object)controllerName, (Object)clusterName, (Object)namespace, (Object)canUpdated));
        } else {
            throw (Throwable)callSiteArray[132].callConstructor(KubernetesOperationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[133].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"Controller type ", " is not support."}));
        }
        return (HasMetadata)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].call(KubernetesClientApiConverter.class, controllerSet), HasMetadata.class);
    }

    public Object deployStatefulSet(KubernetesV1Credentials credentials, String controllerName, String clusterName, String namespace, Boolean canUpdated) {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        callSiteArray[135].call(callSiteArray[136].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building stateful set...");
        Object controllerSet = callSiteArray[137].call(KubernetesClientApiConverter.class, (Object)this.description, (Object)controllerName);
        if (DefaultTypeTransformation.booleanUnbox((Object)canUpdated)) {
            Object deployedControllerSet = callSiteArray[138].call(callSiteArray[139].callGetProperty((Object)credentials), (Object)controllerName, (Object)namespace);
            if (DefaultTypeTransformation.booleanUnbox((Object)deployedControllerSet)) {
                Object object;
                callSiteArray[140].call(callSiteArray[141].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Update stateful set ", ""}));
                controllerSet = object = callSiteArray[142].call(callSiteArray[143].callGetProperty((Object)credentials), (Object)controllerName, (Object)namespace, controllerSet);
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[144].call(callSiteArray[145].callGetPropertySafe(callSiteArray[146].callGetPropertySafe(callSiteArray[147].callGroovyObjectGetProperty((Object)this.description)))), (Object)"Recreate")) {
                    callSiteArray[148].callCurrent((GroovyObject)this, (Object)credentials, (Object)namespace, controllerSet);
                }
            } else {
                Object object;
                callSiteArray[149].call(callSiteArray[150].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Deployed stateful set ", ""}));
                controllerSet = object = callSiteArray[151].call(callSiteArray[152].callGetProperty((Object)credentials), (Object)namespace, controllerSet);
            }
        } else {
            Object object;
            callSiteArray[153].call(callSiteArray[154].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Deployed stateful set ", ""}));
            controllerSet = object = callSiteArray[155].call(callSiteArray[156].callGetProperty((Object)credentials), (Object)namespace, controllerSet);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[157].callGroovyObjectGetProperty((Object)this.description))) {
            callSiteArray[158].call(callSiteArray[159].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Attaching a horizontal pod autoscaler...");
            Object autoscaler = callSiteArray[160].call(KubernetesClientApiConverter.class, callSiteArray[161].callConstructor(KubernetesAutoscalerDescription.class, (Object)controllerName, (Object)this.description), (Object)controllerName, callSiteArray[162].callGroovyObjectGetProperty((Object)this.description));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[163].call(callSiteArray[164].callGetProperty((Object)credentials), (Object)namespace, (Object)controllerName))) {
                callSiteArray[165].call(callSiteArray[166].callGetProperty((Object)credentials), ArrayUtil.createArray((Object)namespace, (Object)controllerName, null, null, null, (Object)true));
            }
            callSiteArray[167].call(callSiteArray[168].callGetProperty((Object)credentials), (Object)namespace, autoscaler);
        }
        return controllerSet;
    }

    public Object deployDaemonSet(KubernetesV1Credentials credentials, String controllerName, String clusterName, String namespace, boolean canUpdated) {
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        callSiteArray[169].call(callSiteArray[170].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Building daemon set...");
        Object controllerSet = callSiteArray[171].call(KubernetesClientApiConverter.class, (Object)this.description, (Object)controllerName);
        if (canUpdated) {
            Object deployedControllerSet = callSiteArray[172].call(callSiteArray[173].callGetProperty((Object)credentials), (Object)controllerName, (Object)namespace);
            if (DefaultTypeTransformation.booleanUnbox((Object)deployedControllerSet)) {
                Object object;
                callSiteArray[174].call(callSiteArray[175].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Update daemon set ", ""}));
                controllerSet = object = callSiteArray[176].call(callSiteArray[177].callGetProperty((Object)credentials), (Object)controllerName, (Object)namespace, controllerSet);
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[178].call(callSiteArray[179].callGetPropertySafe(callSiteArray[180].callGetPropertySafe(callSiteArray[181].callGroovyObjectGetProperty((Object)this.description)))), (Object)"Recreate")) {
                    callSiteArray[182].callCurrent((GroovyObject)this, (Object)credentials, (Object)namespace, controllerSet);
                }
            } else {
                Object object;
                callSiteArray[183].call(callSiteArray[184].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Deployed daemon set ", ""}));
                controllerSet = object = callSiteArray[185].call(callSiteArray[186].callGetProperty((Object)credentials), (Object)namespace, controllerSet);
            }
        } else {
            Object object;
            callSiteArray[187].call(callSiteArray[188].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{controllerName}, new String[]{"Deployed daemon set ", ""}));
            controllerSet = object = callSiteArray[189].call(callSiteArray[190].callGetProperty((Object)credentials), (Object)namespace, controllerSet);
        }
        return controllerSet;
    }

    /*
     * WARNING - void declaration
     */
    public void deletePods(KubernetesV1Credentials credentials, String namespace, Object controllerSet) {
        void var3_3;
        void var2_2;
        Reference credentials2 = new Reference((Object)credentials);
        Reference namespace2 = new Reference((Object)var2_2);
        Reference controllerSet2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = DeployKubernetesAtomicOperation.$getCallSiteArray();
        Reference podNameList = new Reference((Object)((Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[191].callConstructor(LinkedHashMap.class), Map.class)));
        public class _deletePods_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference podNameList;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deletePods_closure1(Object _outerInstance, Object _thisObject, Reference podNameList) {
                Reference reference;
                CallSite[] callSiteArray = _deletePods_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.podNameList = reference = podNameList;
            }

            public Object doCall(Object item) {
                CallSite[] callSiteArray = _deletePods_closure1.$getCallSiteArray();
                return callSiteArray[0].call(this.podNameList.get(), callSiteArray[1].callGetProperty(callSiteArray[2].callGetProperty(item)), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(item)));
            }

            public Map getPodNameList() {
                CallSite[] callSiteArray = _deletePods_closure1.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.podNameList.get(), Map.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deletePods_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "put";
                stringArray[1] = "name";
                stringArray[2] = "metadata";
                stringArray[3] = "uid";
                stringArray[4] = "metadata";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _deletePods_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deletePods_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deletePods_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[192].call(callSiteArray[193].callGetProperty(callSiteArray[194].call(callSiteArray[195].callGetProperty((Object)((KubernetesV1Credentials)credentials2.get())), (Object)((String)namespace2.get()), callSiteArray[196].callGetProperty(callSiteArray[197].callGetProperty(controllerSet2.get())))), (Object)new _deletePods_closure1(this, this, podNameList));
        Reference getPodState = new Reference(null);
        public class _deletePods_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference namespace;
            private /* synthetic */ Reference getPodState;
            private /* synthetic */ Reference controllerSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _deletePods_closure2(Object _outerInstance, Object _thisObject, Reference credentials, Reference namespace, Reference getPodState, Reference controllerSet) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.credentials = reference4 = credentials;
                this.namespace = reference3 = namespace;
                this.getPodState = reference2 = getPodState;
                this.controllerSet = reference = controllerSet;
            }

            /*
             * WARNING - void declaration
             */
            public Object doCall(Object k, Object v) {
                void var2_2;
                Reference k2 = new Reference(k);
                Reference v2 = new Reference((Object)var2_2);
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGetProperty(this.credentials.get()), ArrayUtil.createArray((Object)k2.get(), (Object)this.namespace.get(), null, null, null, (Object)false));
                public class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference credentials;
                    private /* synthetic */ Reference k;
                    private /* synthetic */ Reference namespace;
                    private /* synthetic */ Reference v;
                    private /* synthetic */ Reference controllerSet;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference credentials, Reference k, Reference namespace, Reference v, Reference controllerSet) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.credentials = reference5 = credentials;
                        this.k = reference4 = k;
                        this.namespace = reference3 = namespace;
                        this.v = reference2 = v;
                        this.controllerSet = reference = controllerSet;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        V1Pod pod = (V1Pod)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(this.credentials.get()), this.k.get(), this.namespace.get()), V1Pod.class);
                        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (DefaultTypeTransformation.booleanUnbox((Object)pod) ? ScriptBytecodeAdapter.compareNotEqual((Object)this.v.get(), (Object)callSiteArray[2].callGetPropertySafe(callSiteArray[3].callGetProperty((Object)pod))) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callGetPropertySafe(callSiteArray[5].callGetProperty((Object)pod)), (Object)"Running") : ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callGetProperty(this.controllerSet.get()), (Object)callSiteArray[7].callGetProperty(KubernetesUtil.class))) : (DefaultTypeTransformation.booleanUnbox((Object)pod) ? ScriptBytecodeAdapter.compareNotEqual((Object)this.v.get(), (Object)callSiteArray[8].callGetPropertySafe(callSiteArray[9].callGetProperty((Object)pod))) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[10].callGetPropertySafe(callSiteArray[11].callGetProperty((Object)pod)), (Object)"Running") : ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[12].callGetProperty(this.controllerSet.get()), (Object)callSiteArray[13].callGetProperty(KubernetesUtil.class)))) {
                            return true;
                        }
                        return false;
                    }

                    public KubernetesV1Credentials getCredentials() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (KubernetesV1Credentials)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), KubernetesV1Credentials.class);
                    }

                    public Object getK() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.k.get();
                    }

                    public String getNamespace() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.namespace.get());
                    }

                    public Object getV() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.v.get();
                    }

                    public Object getControllerSet() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.controllerSet.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "getPodStatus";
                        stringArray[1] = "clientApiAdaptor";
                        stringArray[2] = "uid";
                        stringArray[3] = "metadata";
                        stringArray[4] = "phase";
                        stringArray[5] = "status";
                        stringArray[6] = "kind";
                        stringArray[7] = "CONTROLLERS_DAEMONSET_KIND";
                        stringArray[8] = "uid";
                        stringArray[9] = "metadata";
                        stringArray[10] = "phase";
                        stringArray[11] = "status";
                        stringArray[12] = "kind";
                        stringArray[13] = "CONTROLLERS_DAEMONSET_KIND";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[14];
                        _closure3.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure3.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure3.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                _closure3 _closure32 = new _closure3((Object)this, this.getThisObject(), this.credentials, k2, this.namespace, v2, this.controllerSet);
                this.getPodState.set((Object)_closure32);
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(this.credentials.get()), this.getPodState.get()))) {
                    throw (Throwable)callSiteArray[4].callConstructor(KubernetesClientOperationException.class, (Object)new GStringImpl(new Object[]{k2.get(), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(this.controllerSet.get())), this.namespace.get()}, new String[]{"Failed to launch a new pod(", ") for ServerGroup ", " in ", "."}));
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public Object call(Object k, Object v) {
                void var2_2;
                Reference k2 = new Reference(k);
                Reference v2 = new Reference((Object)var2_2);
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, k2.get(), v2.get());
            }

            public KubernetesV1Credentials getCredentials() {
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return (KubernetesV1Credentials)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), KubernetesV1Credentials.class);
            }

            public String getNamespace() {
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.namespace.get());
            }

            public Object getGetPodState() {
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return this.getPodState.get();
            }

            public Object getControllerSet() {
                CallSite[] callSiteArray = _deletePods_closure2.$getCallSiteArray();
                return this.controllerSet.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deletePods_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "deletePod";
                stringArray[1] = "clientApiAdaptor";
                stringArray[2] = "blockUntilResourceConsistent";
                stringArray[3] = "clientApiAdaptor";
                stringArray[4] = "<$constructor$>";
                stringArray[5] = "name";
                stringArray[6] = "metadata";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _deletePods_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_deletePods_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _deletePods_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[198].call(callSiteArray[199].call((Object)((Map)podNameList.get()), callSiteArray[200].call(callSiteArray[201].call(Map.Entry.class))), (Object)new _deletePods_closure2(this, this, credentials2, namespace2, getPodState, controllerSet2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeployKubernetesAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public final DeployKubernetesAtomicOperationDescription getDescription() {
        return this.description;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "threadLocalTask";
        stringArray[2] = "deployDescription";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "asList";
        stringArray[5] = "toString";
        stringArray[6] = "namespace";
        stringArray[7] = "metadata";
        stringArray[8] = "name";
        stringArray[9] = "metadata";
        stringArray[10] = "name";
        stringArray[11] = "metadata";
        stringArray[12] = "putAt";
        stringArray[13] = "serverGroupNameByRegion";
        stringArray[14] = "namespace";
        stringArray[15] = "metadata";
        stringArray[16] = "updateStatus";
        stringArray[17] = "task";
        stringArray[18] = "updateStatus";
        stringArray[19] = "task";
        stringArray[20] = "credentials";
        stringArray[21] = "credentials";
        stringArray[22] = "namespace";
        stringArray[23] = "source";
        stringArray[24] = "namespace";
        stringArray[25] = "source";
        stringArray[26] = "namespace";
        stringArray[27] = "namespace";
        stringArray[28] = "validateNamespace";
        stringArray[29] = "getAt";
        stringArray[30] = "imagePullSecrets";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "combineAppStackDetail";
        stringArray[33] = "application";
        stringArray[34] = "stack";
        stringArray[35] = "freeFormDetails";
        stringArray[36] = "kind";
        stringArray[37] = "sequence";
        stringArray[38] = "generateServerGroupName";
        stringArray[39] = "application";
        stringArray[40] = "stack";
        stringArray[41] = "freeFormDetails";
        stringArray[42] = "sequence";
        stringArray[43] = "deployController";
        stringArray[44] = "updateStatus";
        stringArray[45] = "task";
        stringArray[46] = "sequence";
        stringArray[47] = "generateServerGroupName";
        stringArray[48] = "application";
        stringArray[49] = "stack";
        stringArray[50] = "freeFormDetails";
        stringArray[51] = "sequence";
        stringArray[52] = "resolveNextServerGroupName";
        stringArray[53] = "application";
        stringArray[54] = "stack";
        stringArray[55] = "freeFormDetails";
        stringArray[56] = "updateStatus";
        stringArray[57] = "task";
        stringArray[58] = "hasDeployment";
        stringArray[59] = "useSourceCapacity";
        stringArray[60] = "source";
        stringArray[61] = "updateStatus";
        stringArray[62] = "task";
        stringArray[63] = "serverGroupName";
        stringArray[64] = "source";
        stringArray[65] = "getReplicationController";
        stringArray[66] = "apiAdaptor";
        stringArray[67] = "serverGroupName";
        stringArray[68] = "source";
        stringArray[69] = "getReplicaSet";
        stringArray[70] = "apiAdaptor";
        stringArray[71] = "serverGroupName";
        stringArray[72] = "source";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "serverGroupName";
        stringArray[75] = "source";
        stringArray[76] = "updateStatus";
        stringArray[77] = "task";
        stringArray[78] = "replicas";
        stringArray[79] = "spec";
        stringArray[80] = "updateStatus";
        stringArray[81] = "task";
        stringArray[82] = "toReplicaSet";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "spec";
        stringArray[85] = "updateStatus";
        stringArray[86] = "task";
        stringArray[87] = "toReplicaSet";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "spec";
        stringArray[90] = "createReplicaSet";
        stringArray[91] = "apiAdaptor";
        stringArray[92] = "updateStatus";
        stringArray[93] = "task";
        stringArray[94] = "name";
        stringArray[95] = "metadata";
        stringArray[96] = "getDeployment";
        stringArray[97] = "apiAdaptor";
        stringArray[98] = "updateStatus";
        stringArray[99] = "task";
        stringArray[100] = "createDeployment";
        stringArray[101] = "apiAdaptor";
        stringArray[102] = "build";
        stringArray[103] = "toDeployment";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "updateStatus";
        stringArray[106] = "task";
        stringArray[107] = "done";
        stringArray[108] = "toDeployment";
        stringArray[109] = "editDeployment";
        stringArray[110] = "apiAdaptor";
        stringArray[111] = "updateStatus";
        stringArray[112] = "task";
        stringArray[113] = "scalingPolicy";
        stringArray[114] = "updateStatus";
        stringArray[115] = "task";
        stringArray[116] = "DEPLOYMENT_KIND";
        stringArray[117] = "SERVER_GROUP_KIND";
        stringArray[118] = "toAutoscaler";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "getAutoscaler";
        stringArray[121] = "apiAdaptor";
        stringArray[122] = "deleteAutoscaler";
        stringArray[123] = "apiAdaptor";
        stringArray[124] = "createAutoscaler";
        stringArray[125] = "apiAdaptor";
        stringArray[126] = "canUpdated";
        stringArray[127] = "kind";
        stringArray[128] = "CONTROLLERS_STATEFULSET_KIND";
        stringArray[129] = "deployStatefulSet";
        stringArray[130] = "CONTROLLERS_DAEMONSET_KIND";
        stringArray[131] = "deployDaemonSet";
        stringArray[132] = "<$constructor$>";
        stringArray[133] = "kind";
        stringArray[134] = "toKubernetesController";
        stringArray[135] = "updateStatus";
        stringArray[136] = "task";
        stringArray[137] = "toStatefulSet";
        stringArray[138] = "getStatefulSet";
        stringArray[139] = "clientApiAdaptor";
        stringArray[140] = "updateStatus";
        stringArray[141] = "task";
        stringArray[142] = "replaceStatfulSet";
        stringArray[143] = "clientApiAdaptor";
        stringArray[144] = "name";
        stringArray[145] = "type";
        stringArray[146] = "updateStrategy";
        stringArray[147] = "updateController";
        stringArray[148] = "deletePods";
        stringArray[149] = "updateStatus";
        stringArray[150] = "task";
        stringArray[151] = "createStatfulSet";
        stringArray[152] = "clientApiAdaptor";
        stringArray[153] = "updateStatus";
        stringArray[154] = "task";
        stringArray[155] = "createStatfulSet";
        stringArray[156] = "clientApiAdaptor";
        stringArray[157] = "scalingPolicy";
        stringArray[158] = "updateStatus";
        stringArray[159] = "task";
        stringArray[160] = "toAutoscaler";
        stringArray[161] = "<$constructor$>";
        stringArray[162] = "kind";
        stringArray[163] = "getAutoscaler";
        stringArray[164] = "clientApiAdaptor";
        stringArray[165] = "deleteAutoscaler";
        stringArray[166] = "clientApiAdaptor";
        stringArray[167] = "createAutoscaler";
        stringArray[168] = "clientApiAdaptor";
        stringArray[169] = "updateStatus";
        stringArray[170] = "task";
        stringArray[171] = "toDaemonSet";
        stringArray[172] = "getDaemonSet";
        stringArray[173] = "clientApiAdaptor";
        stringArray[174] = "updateStatus";
        stringArray[175] = "task";
        stringArray[176] = "replaceDaemonSet";
        stringArray[177] = "clientApiAdaptor";
        stringArray[178] = "name";
        stringArray[179] = "type";
        stringArray[180] = "updateStrategy";
        stringArray[181] = "updateController";
        stringArray[182] = "deletePods";
        stringArray[183] = "updateStatus";
        stringArray[184] = "task";
        stringArray[185] = "createDaemonSet";
        stringArray[186] = "clientApiAdaptor";
        stringArray[187] = "updateStatus";
        stringArray[188] = "task";
        stringArray[189] = "createDaemonSet";
        stringArray[190] = "clientApiAdaptor";
        stringArray[191] = "<$constructor$>";
        stringArray[192] = "forEach";
        stringArray[193] = "items";
        stringArray[194] = "getPods";
        stringArray[195] = "clientApiAdaptor";
        stringArray[196] = "labels";
        stringArray[197] = "metadata";
        stringArray[198] = "forEach";
        stringArray[199] = "toSorted";
        stringArray[200] = "reversed";
        stringArray[201] = "comparingByKey";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[202];
        DeployKubernetesAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DeployKubernetesAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DeployKubernetesAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

