/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2OnDemandCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesReplicaSetHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesServiceHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class KubernetesServiceCachingAgent
extends KubernetesV2OnDemandCachingAgent {
    private final Collection<AgentDataType> providedDataTypes = Collections.unmodifiableSet(new HashSet<AgentDataType>(Arrays.asList(AgentDataType.Authority.INFORMATIVE.forType(Keys.LogicalKind.APPLICATIONS.toString()), AgentDataType.Authority.INFORMATIVE.forType(KubernetesKind.POD.toString()), AgentDataType.Authority.INFORMATIVE.forType(KubernetesKind.REPLICA_SET.toString()), AgentDataType.Authority.AUTHORITATIVE.forType(KubernetesKind.SERVICE.toString()))));

    protected KubernetesServiceCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount);
    }

    @Override
    protected KubernetesKind primaryKind() {
        return KubernetesKind.SERVICE;
    }

    @Override
    protected Map<KubernetesManifest, List<KubernetesManifest>> loadSecondaryResourceRelationships(List<KubernetesManifest> services) {
        HashMap<String, Set<KubernetesManifest>> mapLabelToManifest = new HashMap<String, Set<KubernetesManifest>>();
        this.namespaces.stream().map(n -> ((KubernetesV2Credentials)this.credentials).list(KubernetesKind.REPLICA_SET, (String)n)).flatMap(Collection::stream).collect(Collectors.toList()).forEach(r -> KubernetesServiceCachingAgent.addAllReplicaSetLabels(mapLabelToManifest, r));
        HashMap<KubernetesManifest, List<KubernetesManifest>> result = new HashMap<KubernetesManifest, List<KubernetesManifest>>();
        for (KubernetesManifest service : services) {
            result.put(service, KubernetesServiceCachingAgent.getRelatedManifests(service, mapLabelToManifest));
        }
        return result;
    }

    private static List<KubernetesManifest> getRelatedManifests(KubernetesManifest service, Map<String, Set<KubernetesManifest>> mapLabelToManifest) {
        return new ArrayList<KubernetesManifest>(KubernetesServiceCachingAgent.intersectLabels(service, mapLabelToManifest));
    }

    private static Set<KubernetesManifest> intersectLabels(KubernetesManifest service, Map<String, Set<KubernetesManifest>> mapLabelToManifest) {
        Map<String, String> selector = KubernetesServiceHandler.getSelector(service);
        if (selector == null || selector.isEmpty()) {
            return new HashSet<KubernetesManifest>();
        }
        HashSet result = null;
        String namespace = service.getNamespace();
        for (Map.Entry<String, String> label : selector.entrySet()) {
            String labelKey = KubernetesServiceCachingAgent.podLabelKey(namespace, label);
            HashSet manifests = mapLabelToManifest.get(labelKey);
            HashSet hashSet = manifests = manifests == null ? new HashSet() : manifests;
            if (result == null) {
                result = manifests;
                continue;
            }
            result.retainAll(manifests);
        }
        return result;
    }

    private static void addAllReplicaSetLabels(Map<String, Set<KubernetesManifest>> entries, KubernetesManifest replicaSet) {
        String namespace = replicaSet.getNamespace();
        Map<String, String> podLabels = KubernetesReplicaSetHandler.getPodTemplateLabels(replicaSet);
        if (podLabels == null) {
            return;
        }
        for (Map.Entry<String, String> label : podLabels.entrySet()) {
            String labelKey = KubernetesServiceCachingAgent.podLabelKey(namespace, label);
            KubernetesServiceCachingAgent.enterManifest(entries, labelKey, KubernetesCacheDataConverter.convertToManifest(replicaSet));
        }
    }

    private static void enterManifest(Map<String, Set<KubernetesManifest>> entries, String label, KubernetesManifest manifest) {
        Set<KubernetesManifest> pods = entries.get(label);
        if (pods == null) {
            pods = new HashSet<KubernetesManifest>();
        }
        pods.add(manifest);
        entries.put(label, pods);
    }

    private static String podLabelKey(String namespace, Map.Entry<String, String> label) {
        return namespace + " " + label.getKey() + " " + label.getValue();
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.providedDataTypes;
    }
}

