/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupport;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.moniker.Namer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubernetesV2OnDemandCachingAgent
extends KubernetesV2CachingAgent
implements OnDemandAgent {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2OnDemandCachingAgent.class);
    protected final OnDemandMetricsSupport metricsSupport;
    protected static final String ON_DEMAND_TYPE = "onDemand";
    private static final String CACHE_TIME_KEY = "cacheTime";
    private static final String PROCESSED_COUNT_KEY = "processedCount";
    private static final String PROCESSED_TIME_KEY = "processedTime";
    private static final String CACHE_RESULTS_KEY = "cacheResults";
    private static final String MONIKER_KEY = "moniker";
    private static final String DETAILS_KEY = "details";
    private final Namer<KubernetesManifest> namer;

    protected KubernetesV2OnDemandCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount) {
        super(namedAccountCredentials, objectMapper, registry, agentIndex, agentCount);
        this.namer = NamerRegistry.lookup().withProvider(KubernetesCloudProvider.getID()).withAccount(namedAccountCredentials.getName()).withResource(KubernetesManifest.class);
        this.metricsSupport = new OnDemandMetricsSupport(registry, (OnDemandAgent)this, KubernetesCloudProvider.getID() + ":" + OnDemandAgent.OnDemandType.Manifest);
    }

    @Override
    public CacheResult loadData(ProviderCache providerCache) {
        log.info(this.getAgentType() + " is starting");
        this.reloadNamespaces();
        Long start = System.currentTimeMillis();
        List<KubernetesManifest> primaryResource = this.loadPrimaryResourceList();
        List primaryKeys = primaryResource.stream().map(rs -> (KubernetesManifest)this.objectMapper.convertValue(rs, KubernetesManifest.class)).map(mf -> Keys.infrastructure(mf, this.accountName)).collect(Collectors.toList());
        ArrayList<CacheData> keepInOnDemand = new ArrayList<CacheData>();
        ArrayList evictFromOnDemand = new ArrayList();
        providerCache.getAll(ON_DEMAND_TYPE, primaryKeys).forEach(cd -> {
            if (this.shouldKeepInOnDemand(start, (CacheData)cd)) {
                keepInOnDemand.add((CacheData)cd);
            } else {
                evictFromOnDemand.add(cd);
            }
            this.processOnDemandEntry((CacheData)cd);
        });
        keepInOnDemand.sort(Comparator.comparing(a -> (Long)a.getAttributes().get(CACHE_TIME_KEY)));
        CacheResult result = this.buildCacheResult(primaryResource);
        Map cacheResults = result.getCacheResults();
        for (CacheData onDemandData : keepInOnDemand) {
            Map onDemandResults;
            String onDemandKey = onDemandData.getId();
            log.info("On demand entry '{}' is overwriting load data entry", (Object)onDemandKey);
            String onDemandResultsJson = (String)onDemandData.getAttributes().get(CACHE_RESULTS_KEY);
            try {
                onDemandResults = (Map)this.objectMapper.readValue(onDemandResultsJson, (TypeReference)new TypeReference<Map<String, List<DefaultCacheData>>>(){});
            }
            catch (IOException e) {
                log.error("Failure parsing stored on demand data for '{}'", (Object)onDemandKey, (Object)e);
                continue;
            }
            this.mergeCacheResults(cacheResults, onDemandResults);
        }
        cacheResults.put(ON_DEMAND_TYPE, keepInOnDemand);
        ImmutableMap evictionResults = new ImmutableMap.Builder().put((Object)ON_DEMAND_TYPE, evictFromOnDemand.stream().map(CacheData::getId).collect(Collectors.toList())).build();
        return new DefaultCacheResult(cacheResults, (Map)evictionResults);
    }

    protected void mergeCacheResults(Map<String, Collection<CacheData>> current, Map<String, Collection<CacheData>> added) {
        for (String group : added.keySet()) {
            ArrayList<CacheData> currentByGroup = current.get(group);
            ArrayList addedByGroup = added.get(group);
            currentByGroup = currentByGroup == null ? new ArrayList<CacheData>() : currentByGroup;
            addedByGroup = addedByGroup == null ? new ArrayList() : addedByGroup;
            for (CacheData addedCacheData : addedByGroup) {
                CacheData mergedEntry = currentByGroup.stream().filter(cd -> cd.getId().equals(addedCacheData.getId())).findFirst().flatMap(cd -> Optional.of(KubernetesCacheDataConverter.mergeCacheData(cd, addedCacheData))).orElse(addedCacheData);
                currentByGroup.removeIf(cd -> cd.getId().equals(addedCacheData.getId()));
                currentByGroup.add(mergedEntry);
            }
            current.put(group, currentByGroup);
        }
    }

    private void processOnDemandEntry(CacheData onDemandEntry) {
        Map attributes = onDemandEntry.getAttributes();
        Integer processedCount = (Integer)attributes.get(PROCESSED_COUNT_KEY);
        Long processedTime = System.currentTimeMillis();
        processedCount = processedCount == null ? 0 : processedCount;
        processedCount = processedCount + 1;
        attributes.put(PROCESSED_TIME_KEY, processedTime);
        attributes.put(PROCESSED_COUNT_KEY, processedCount);
    }

    private boolean shouldKeepInOnDemand(Long lastFullRefresh, CacheData onDemandEntry) {
        Map attributes = onDemandEntry.getAttributes();
        Long cacheTime = (Long)attributes.get(CACHE_TIME_KEY);
        Integer processedCount = (Integer)attributes.get(PROCESSED_COUNT_KEY);
        cacheTime = cacheTime == null ? 0L : cacheTime;
        processedCount = processedCount == null ? 0 : processedCount;
        return cacheTime >= lastFullRefresh || processedCount == 0;
    }

    private OnDemandAgent.OnDemandResult evictEntry(ProviderCache providerCache, String key) {
        HashMap<String, List<String>> evictions = new HashMap<String, List<String>>();
        DefaultCacheResult cacheResult = new DefaultCacheResult(new HashMap());
        log.info("Evicting on demand '{}'", (Object)key);
        providerCache.evictDeletedItems(ON_DEMAND_TYPE, Collections.singletonList(key));
        evictions.put(this.primaryKind().toString(), Collections.singletonList(key));
        return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), (CacheResult)cacheResult, evictions);
    }

    private OnDemandAgent.OnDemandResult addEntry(ProviderCache providerCache, String key, KubernetesManifest manifest) throws JsonProcessingException {
        HashMap evictions = new HashMap();
        log.info("Storing on demand '{}'", (Object)key);
        CacheResult cacheResult = this.buildCacheResult(manifest);
        String jsonResult = this.objectMapper.writeValueAsString((Object)cacheResult.getCacheResults());
        ImmutableMap attributes = new ImmutableMap.Builder().put((Object)CACHE_TIME_KEY, (Object)System.currentTimeMillis()).put((Object)CACHE_RESULTS_KEY, (Object)jsonResult).put((Object)PROCESSED_COUNT_KEY, (Object)0).put((Object)PROCESSED_TIME_KEY, (Object)-1).put((Object)MONIKER_KEY, (Object)this.namer.deriveMoniker((Object)manifest)).build();
        HashMap relationships = new HashMap();
        DefaultCacheData onDemandData = new DefaultCacheData(key, (Map)attributes, relationships);
        providerCache.putCacheData(ON_DEMAND_TYPE, (CacheData)onDemandData);
        return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), cacheResult, evictions);
    }

    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ?> data) {
        OnDemandAgent.OnDemandResult result;
        String name;
        String account = (String)data.get("account");
        String namespace = (String)data.get("location");
        String fullName = (String)data.get("name");
        try {
            Pair<KubernetesKind, String> parsedName = KubernetesManifest.fromFullResourceName(fullName);
            if (parsedName.getLeft() != this.primaryKind()) {
                return null;
            }
            name = (String)parsedName.getRight();
        }
        catch (Exception e) {
            return null;
        }
        this.reloadNamespaces();
        if (StringUtils.isEmpty((CharSequence)account) || StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)namespace) || !this.namespaces.contains(namespace)) {
            return null;
        }
        log.info("Accepted on demand refresh of '{}'", data);
        KubernetesManifest manifest = this.loadPrimaryResource(namespace, name);
        String resourceKey = Keys.infrastructure(this.primaryKind(), account, namespace, name);
        try {
            result = manifest == null ? this.evictEntry(providerCache, resourceKey) : this.addEntry(providerCache, resourceKey, manifest);
        }
        catch (Exception e) {
            log.error("Failed to process update of '{}'", (Object)resourceKey, (Object)e);
            return null;
        }
        log.info("On demand cache refresh of (data: {}) succeeded", data);
        return result;
    }

    public String getOnDemandAgentType() {
        return this.getAgentType() + "-OnDemand";
    }

    public boolean handles(OnDemandAgent.OnDemandType type, String cloudProvider) {
        return type == OnDemandAgent.OnDemandType.Manifest && cloudProvider.equals(KubernetesCloudProvider.getID());
    }

    public Collection<Map> pendingOnDemandRequests(ProviderCache providerCache) {
        Collection keys = providerCache.getIdentifiers(ON_DEMAND_TYPE);
        List infraKeys = keys.stream().map(Keys::parseKey).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).filter(k -> k instanceof Keys.InfrastructureCacheKey).map(i -> (Keys.InfrastructureCacheKey)i).collect(Collectors.toList());
        List matchingKeys = infraKeys.stream().filter(i -> i.getAccount().equals(this.getAccountName()) && this.namespaces.contains(i.getNamespace()) && i.getKubernetesKind().equals(this.primaryKind())).map(Keys.InfrastructureCacheKey::toString).collect(Collectors.toList());
        return providerCache.getAll(ON_DEMAND_TYPE, matchingKeys).stream().map(cd -> {
            Keys.InfrastructureCacheKey parsedKey = (Keys.InfrastructureCacheKey)Keys.parseKey(cd.getId()).get();
            Map<String, String> details = this.mapKeyToOnDemandResult(parsedKey);
            Map attributes = cd.getAttributes();
            return new ImmutableMap.Builder().put((Object)DETAILS_KEY, details).put((Object)MONIKER_KEY, attributes.get(MONIKER_KEY)).put((Object)CACHE_TIME_KEY, attributes.get(CACHE_TIME_KEY)).put((Object)PROCESSED_COUNT_KEY, attributes.get(PROCESSED_COUNT_KEY)).put((Object)PROCESSED_TIME_KEY, attributes.get(PROCESSED_TIME_KEY)).build();
        }).collect(Collectors.toList());
    }

    private Map<String, String> mapKeyToOnDemandResult(Keys.InfrastructureCacheKey key) {
        return new ImmutableMap.Builder().put((Object)"name", (Object)KubernetesManifest.getFullResourceName(key.getKubernetesKind(), key.getName())).put((Object)"account", (Object)key.getAccount()).put((Object)"location", (Object)key.getNamespace()).build();
    }

    public OnDemandMetricsSupport getMetricsSupport() {
        return this.metricsSupport;
    }
}

