/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class KubernetesHandler {
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected KubectlJobExecutor jobExecutor;
    private ArtifactReplacer artifactReplacer = new ArtifactReplacer();

    protected void registerReplacer(ArtifactReplacer.Replacer replacer) {
        this.artifactReplacer.addReplacer(replacer);
    }

    public ArtifactReplacer.ReplaceResult replaceArtifacts(KubernetesManifest manifest, List<Artifact> artifacts) {
        return this.artifactReplacer.replaceAll(manifest, artifacts);
    }

    public Set<Artifact> listArtifacts(KubernetesManifest manifest) {
        return this.artifactReplacer.findAll(manifest);
    }

    public OperationResult deployAugmentedManifest(KubernetesV2Credentials credentials, KubernetesManifest manifest) {
        this.deploy(credentials, manifest);
        return new OperationResult().addManifest(manifest);
    }

    public abstract KubernetesKind kind();

    public abstract boolean versioned();

    public abstract KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind();

    public abstract Manifest.Status status(KubernetesManifest var1);

    public abstract Class<? extends KubernetesV2CachingAgent> cachingAgentClass();

    protected void deploy(KubernetesV2Credentials credentials, KubernetesManifest manifest) {
        credentials.deploy(manifest);
    }

    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map result = (Map)this.objectMapper.convertValue((Object)key, (TypeReference)new TypeReference<Map<String, Object>>(){});
        result.put("region", key.getNamespace());
        result.put("name", KubernetesManifest.getFullResourceName(key.getKubernetesKind(), key.getName()));
        return result;
    }

    public KubectlJobExecutor getJobExecutor() {
        return this.jobExecutor;
    }
}

