/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesPauseRolloutManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesPauseRolloutManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesPauseRolloutManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final KubernetesResourcePropertyRegistry registry;
    private static final String OP_NAME = "PAUSE_ROLLOUT_KUBERNETES_MANIFEST";

    public KubernetesPauseRolloutManifestOperation(KubernetesPauseRolloutManifestDescription description, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.registry = registry;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        KubernetesPauseRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Starting pause rollout operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesPauseRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesResourceProperties properties = this.registry.get(coordinates.getKind());
        KubernetesHandler deployer = properties.getHandler();
        if (!(deployer instanceof CanPauseRollout)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support pause rollout");
        }
        CanPauseRollout canPauseRollout = (CanPauseRollout)((Object)deployer);
        KubernetesPauseRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Calling pause rollout operation...");
        canPauseRollout.pauseRollout(this.credentials, coordinates.getNamespace(), coordinates.getName());
        return null;
    }
}

