/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesUndoRolloutManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesUndoRolloutManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesUndoRolloutManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final KubernetesResourcePropertyRegistry registry;
    private static final String OP_NAME = "DELETE_KUBERNETES_MANIFEST";

    public KubernetesUndoRolloutManifestOperation(KubernetesUndoRolloutManifestDescription description, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.registry = registry;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Starting undo rollout operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesResourceProperties properties = this.registry.get(coordinates.getKind());
        KubernetesHandler deployer = properties.getHandler();
        if (!(deployer instanceof CanUndoRollout)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support undo rollout");
        }
        CanUndoRollout canUndoRollout = (CanUndoRollout)((Object)deployer);
        Integer revision = this.description.getRevision();
        if (this.description.getNumRevisionsBack() != null) {
            KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Looking up rollout history...");
            List<Integer> revisions = canUndoRollout.historyRollout(this.credentials, coordinates.getNamespace(), coordinates.getName());
            revisions.sort(Integer::compareTo);
            int numRevisions = revisions.size();
            int targetRevisionIndex = numRevisions - this.description.getNumRevisionsBack() - 1;
            if (targetRevisionIndex < 0) {
                throw new IllegalArgumentException("There are " + numRevisions + " revision(s) in total, cannot rollback " + this.description.getNumRevisionsBack());
            }
            revision = revisions.get(targetRevisionIndex);
            KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Picked revision " + revision + "...");
        }
        KubernetesUndoRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Calling undo rollout operation...");
        canUndoRollout.undoRollout(this.credentials, coordinates.getNamespace(), coordinates.getName(), revision);
        return null;
    }
}

