/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj.certutil;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.CertificationRequest;
import cn.com.infosec.asn1.x500.X500Name;
import cn.com.infosec.asn1.x509.Extension;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.cert.X509v3CertificateBuilder;
import cn.com.infosec.cert.jcajce.JcaX509CertificateConverter;
import cn.com.infosec.isfj.Config;
import cn.com.infosec.isfj.certutil.X509CertificateParser;
import cn.com.infosec.isfj.cryptoutil.SM2AlgoUtil;
import cn.com.infosec.isfj.formatutil.EncodeUtil;
import cn.com.infosec.jce.X509KeyUsage;
import cn.com.infosec.operator.jcajce.JcaContentSignerBuilder;
import cn.com.infosec.util.encoders.Base64;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Random;

public class SM2CertUtil {
    public static String signSM2CertFromReq(String caCert, String caPrvkey, String breq, String keyUsage, int validityMonths) throws Exception {
        ASN1Sequence seq = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])Base64.decode((String)breq));
        CertificationRequest cr = CertificationRequest.getInstance((Object)seq);
        SubjectPublicKeyInfo pkinfo = cr.getCertificationRequestInfo().getSubjectPublicKeyInfo();
        String publickeyAlg = pkinfo.getAlgorithm().getAlgorithm().getId();
        if (!publickeyAlg.equals(X9ObjectIdentifiers.id_ecPublicKey.getId()) && publickeyAlg.equals(GMObjectIdentifiers.sm2p256v1.getId())) {
            throw new RuntimeException("public algorithm  " + publickeyAlg + " is not sm2");
        }
        Date nb = new Date(System.currentTimeMillis() - 3600000L);
        if (validityMonths <= 0) {
            validityMonths = 60;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, validityMonths);
        Date na = c.getTime();
        X509KeyUsage ku = new X509KeyUsage(128);
        if (keyUsage.toUpperCase().endsWith("SIGN")) {
            ku = new X509KeyUsage(192);
        } else if (keyUsage.toUpperCase().endsWith("ENC")) {
            ku = new X509KeyUsage(48);
        }
        Random r = new Random();
        X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(X500Name.getInstance((Object)X509CertificateParser.certParser(caCert).getSubjectDN()), BigInteger.valueOf(Math.abs(r.nextLong())), nb, na, Locale.CHINA, cr.getCertificationRequestInfo().getSubject(), pkinfo).addExtension(Extension.keyUsage, false, (ASN1Encodable)ku);
        X509Certificate certificate = new JcaX509CertificateConverter().setProvider(Config.getProviderName()).getCertificate(certGen.build(new JcaContentSignerBuilder("SM3withSM2").setProvider(Config.getProviderName()).build(SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(caPrvkey)))));
        return EncodeUtil.base64Encode(certificate.getEncoded());
    }
}

