/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj.cryptoutil;

import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.cms.CMSObjectIdentifiers;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.cert.X509CertificateHolder;
import cn.com.infosec.cert.jcajce.JcaCertStore;
import cn.com.infosec.cms.CMSEnvelopedData;
import cn.com.infosec.cms.CMSEnvelopedDataGenerator;
import cn.com.infosec.cms.CMSProcessable;
import cn.com.infosec.cms.CMSProcessableByteArray;
import cn.com.infosec.cms.CMSSignedData;
import cn.com.infosec.cms.CMSSignedDataGenerator;
import cn.com.infosec.cms.CMSTypedData;
import cn.com.infosec.cms.Recipient;
import cn.com.infosec.cms.RecipientInfoGenerator;
import cn.com.infosec.cms.RecipientInformation;
import cn.com.infosec.cms.RecipientInformationStore;
import cn.com.infosec.cms.SignerInformation;
import cn.com.infosec.cms.SignerInformationStore;
import cn.com.infosec.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import cn.com.infosec.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import cn.com.infosec.cms.jcajce.JceCMSContentEncryptorBuilder;
import cn.com.infosec.cms.jcajce.JceKeyTransEnvelopedRecipient;
import cn.com.infosec.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.agreement.SM2KeyExchange;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ParametersWithID;
import cn.com.infosec.crypto.params.SM2KeyExchangePrivateParameters;
import cn.com.infosec.crypto.params.SM2KeyExchangePublicParameters;
import cn.com.infosec.isfj.Config;
import cn.com.infosec.isfj.certutil.X509CertificateParser;
import cn.com.infosec.isfj.cryptoutil.KDFUtil;
import cn.com.infosec.isfj.formatutil.EncodeUtil;
import cn.com.infosec.jcajce.provider.asymmetric.sm2.SM2PrivateKey;
import cn.com.infosec.jcajce.provider.asymmetric.sm2.SM2PublicKey;
import cn.com.infosec.jcajce.provider.asymmetric.util.SM2Util;
import cn.com.infosec.jce.provider.INFOSECProvider;
import cn.com.infosec.jce.spec.ECNamedCurveSpec;
import cn.com.infosec.math.ec.ECConstants;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.math.ec.FixedPointCombMultiplier;
import cn.com.infosec.math.ec.WNafUtil;
import cn.com.infosec.operator.ContentSigner;
import cn.com.infosec.operator.jcajce.JcaContentSignerBuilder;
import cn.com.infosec.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cn.com.infosec.util.BigIntegerUtil;
import cn.com.infosec.util.Selector;
import cn.com.infosec.util.Store;
import cn.com.infosec.util.Strings;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.Cipher;

public class SM2AlgoUtil {
    static X9ECParameters param = X962NamedCurves.getByName((String)"prime256v1_sm2");
    static ECDomainParameters domainParams = new ECDomainParameters(param.getCurve(), param.getG(), param.getN());
    private static String SM2 = "SM2";
    private static String SM3WITHSM2 = "SM3withSM2";
    private static String PROVIDER = Config.getProviderName();

    public static String[] genSM2KeyPairWithFactor(String factor, boolean isDer) {
        BigInteger bigInteger;
        BigInteger n = param.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while (true) {
            byte[] bytes;
            if ((bigInteger = BigIntegerUtil.toPositiveInteger((byte[])(bytes = KDFUtil.KDF(factor.getBytes(), 32)))).compareTo(ECConstants.ONE) < 0 || bigInteger.compareTo(n) >= 0) {
                factor = factor + "AA";
                continue;
            }
            if (WNafUtil.getNafWeight((BigInteger)bigInteger) >= minWeight) break;
            factor = factor + "AA";
        }
        ECPoint Q = new FixedPointCombMultiplier().multiply(domainParams.getG(), bigInteger);
        AsymmetricCipherKeyPair pair = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)new ECPublicKeyParameters(Q, domainParams), (AsymmetricKeyParameter)new ECPrivateKeyParameters(bigInteger, domainParams));
        ECPublicKeyParameters publicKey = (ECPublicKeyParameters)pair.getPublic();
        ECPrivateKeyParameters privateKey = (ECPrivateKeyParameters)pair.getPrivate();
        ECNamedCurveSpec ecParams = new ECNamedCurveSpec("prime256v1_sm2", param.getCurve(), param.getG(), param.getN(), param.getH(), null);
        ECParameterSpec p = (ECParameterSpec)ecParams;
        SM2PublicKey pubKey = new SM2PublicKey("SM2", publicKey, p, INFOSECProvider.CONFIGURATION);
        KeyPair keyPair = new KeyPair((PublicKey)pubKey, (PrivateKey)new SM2PrivateKey("SM2", privateKey, pubKey, p, INFOSECProvider.CONFIGURATION));
        SM2PrivateKey priv = (SM2PrivateKey)keyPair.getPrivate();
        SM2PublicKey pub = (SM2PublicKey)keyPair.getPublic();
        if (isDer) {
            byte[] bytes1 = priv.getEncoded();
            byte[] bytes2 = pub.getEncoded();
            return new String[]{EncodeUtil.base64Encode(priv.getEncoded()), EncodeUtil.base64Encode(pub.getEncoded())};
        }
        byte[] s = priv.getD().toByteArray();
        byte[] d = new byte[32];
        if (s.length > 32) {
            System.arraycopy(s, s.length - 32, d, 0, 32);
        } else {
            System.arraycopy(s, 0, d, d.length - s.length, s.length);
        }
        byte[] q = pub.getQ().getEncoded(false);
        return new String[]{EncodeUtil.base64Encode(d), EncodeUtil.base64Encode(q)};
    }

    public static String[] genSM2KeyPair(boolean isDer) {
        KeyPair kp = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("SM2", PROVIDER);
            kpg.initialize(256);
            kp = kpg.genKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        SM2PrivateKey priv = (SM2PrivateKey)kp.getPrivate();
        SM2PublicKey pub = (SM2PublicKey)kp.getPublic();
        if (isDer) {
            byte[] bytes1 = priv.getEncoded();
            byte[] bytes2 = pub.getEncoded();
            return new String[]{EncodeUtil.base64Encode(priv.getEncoded()), EncodeUtil.base64Encode(pub.getEncoded())};
        }
        byte[] s = priv.getD().toByteArray();
        byte[] d = new byte[32];
        if (s.length > 32) {
            System.arraycopy(s, s.length - 32, d, 0, 32);
        } else {
            System.arraycopy(s, 0, d, d.length - s.length, s.length);
        }
        byte[] q = pub.getQ().getEncoded(false);
        return new String[]{EncodeUtil.base64Encode(d), EncodeUtil.base64Encode(q)};
    }

    public static String sm2Encrypt(String pub, String tbEnc) throws Exception {
        if (pub == null || pub.isEmpty()) {
            throw new RuntimeException("pubKey can not be null");
        }
        if (tbEnc == null || tbEnc.isEmpty()) {
            throw new RuntimeException("tbEnc can not be null");
        }
        PublicKey pubKey = SM2AlgoUtil.formatPublicKey(EncodeUtil.base64Decode(pub));
        Cipher cipher = Cipher.getInstance("SM2", PROVIDER);
        cipher.init(1, pubKey);
        byte[] tTemp = cipher.doFinal(EncodeUtil.base64Decode(tbEnc));
        return EncodeUtil.base64Encode(tTemp);
    }

    public static String sm2Decrypt(String prv, String tbDec) throws Exception {
        if (prv == null || prv.isEmpty()) {
            throw new RuntimeException("priKey can not be null");
        }
        if (tbDec == null || tbDec.isEmpty()) {
            throw new RuntimeException("tbDec can not be null");
        }
        PrivateKey prvKey = SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(prv));
        Cipher cipher = Cipher.getInstance("SM2", PROVIDER);
        cipher.init(2, prvKey);
        byte[] tTemp = cipher.doFinal(EncodeUtil.base64Decode(tbDec));
        return EncodeUtil.base64Encode(tTemp);
    }

    public static String sm2RawSign(String priKey, String tbsign) throws Exception {
        if (priKey == null || priKey.isEmpty()) {
            throw new RuntimeException("priKey can not be null");
        }
        if (tbsign == null || tbsign.isEmpty()) {
            throw new RuntimeException("tbsign can not be null");
        }
        PrivateKey key = SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(priKey));
        Signature sign = Signature.getInstance(SM2, PROVIDER);
        sign.initSign(key);
        sign.update(EncodeUtil.base64Decode(tbsign));
        return EncodeUtil.base64Encode(sign.sign());
    }

    public static boolean sm2RawVerify(String pub, String tbs, String signature) throws Exception {
        if (pub == null || pub.isEmpty()) {
            throw new RuntimeException("pubKey can not be null");
        }
        if (tbs == null || tbs.isEmpty()) {
            throw new RuntimeException("tbs can not be null");
        }
        if (signature == null || signature.isEmpty()) {
            throw new RuntimeException("signature can not be null");
        }
        PublicKey pubKey = SM2AlgoUtil.formatPublicKey(EncodeUtil.base64Decode(pub));
        Signature sign = Signature.getInstance(SM2, PROVIDER);
        sign.initVerify(pubKey);
        sign.update(EncodeUtil.base64Decode(tbs));
        return sign.verify(EncodeUtil.base64Decode(signature));
    }

    public static String sm2SignMessage(String priKey, String tbsign, String cert, boolean attach) throws Exception {
        if (tbsign == null || tbsign.isEmpty()) {
            throw new RuntimeException("tbsign can not be null");
        }
        PrivateKey key = SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(priKey));
        CMSProcessableByteArray msg = new CMSProcessableByteArray(CMSObjectIdentifiers.gm_data, EncodeUtil.base64Decode(tbsign));
        X509Certificate cerx509 = X509CertificateParser.certParser(cert);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(cerx509);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sm2Signer = new JcaContentSignerBuilder(SM3WITHSM2).setProvider(PROVIDER).build(key);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(PROVIDER).build()).build(sm2Signer, cerx509));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, attach);
        return EncodeUtil.base64Encode(sigData.getEncoded());
    }

    public static boolean sm2VerifyMessage(String signedData, String tbsign, boolean attach) throws Exception {
        boolean verifyRet = true;
        try {
            CMSSignedData sign = null;
            if (attach) {
                sign = new CMSSignedData(EncodeUtil.base64Decode(signedData));
            } else {
                CMSProcessableByteArray msg = new CMSProcessableByteArray(EncodeUtil.base64Decode(tbsign));
                sign = new CMSSignedData((CMSProcessable)msg, EncodeUtil.base64Decode(signedData));
            }
            Store certs = sign.getCertificates();
            SignerInformationStore signers = sign.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                Collection certCollection = certs.getMatches((Selector)signer.getSID());
                Iterator certIt = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(PROVIDER).build(cert))) {
                    verifyRet = true;
                    continue;
                }
                verifyRet = false;
            }
        }
        catch (Exception e) {
            verifyRet = false;
            throw e;
        }
        return verifyRet;
    }

    public static String sm2EnvelopeMessage(String srcMsg, String cert) throws Exception {
        X509Certificate cerx509 = X509CertificateParser.certParser(cert);
        String publickeyAlg = cerx509.getPublicKey().getAlgorithm();
        if (!publickeyAlg.equalsIgnoreCase("EC") && !publickeyAlg.equalsIgnoreCase("SM2")) {
            throw new RuntimeException("the algorithm" + publickeyAlg + "not support");
        }
        CMSProcessableByteArray msg = new CMSProcessableByteArray(CMSObjectIdentifiers.gm_data, EncodeUtil.base64Decode(srcMsg));
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        edGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cerx509).setProvider(PROVIDER));
        CMSEnvelopedData ed = edGen.generate((CMSTypedData)msg, new JceCMSContentEncryptorBuilder(GMObjectIdentifiers.sms4_cbc).setProvider(PROVIDER).build());
        return EncodeUtil.base64Encode(ed.getEncoded());
    }

    public static String sm2OpenEnvelope(String envelopedData, String prvKey) throws Exception {
        CMSEnvelopedData ed = new CMSEnvelopedData(EncodeUtil.base64Decode(envelopedData));
        RecipientInformationStore recipients = ed.getRecipientInfos();
        Collection c = recipients.getRecipients();
        Iterator it = c.iterator();
        PrivateKey key = SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(prvKey));
        byte[] recData = null;
        if (it.hasNext()) {
            RecipientInformation recipient = (RecipientInformation)it.next();
            recData = recipient.getContent((Recipient)new JceKeyTransEnvelopedRecipient(key).setProvider(PROVIDER));
        }
        return EncodeUtil.base64Encode(recData);
    }

    public static String keyExchange(String selfprv, String selfeprv, String peerpub, String peerepub, String selfid, String peerid, boolean isInitiator) throws Exception {
        SM2KeyExchange exch = new SM2KeyExchange();
        ECPrivateKeyParameters aPriv = new ECPrivateKeyParameters(new BigInteger(1, EncodeUtil.base64Decode(selfprv)), domainParams);
        ECPrivateKeyParameters aePriv = new ECPrivateKeyParameters(new BigInteger(1, EncodeUtil.base64Decode(selfeprv)), domainParams);
        ECPublicKeyParameters bPub = new ECPublicKeyParameters(SM2Util.pack2Point((byte[])EncodeUtil.base64Decode(peerpub)), domainParams);
        ECPublicKeyParameters bePub = new ECPublicKeyParameters(SM2Util.pack2Point((byte[])EncodeUtil.base64Decode(peerepub)), domainParams);
        exch.init((CipherParameters)new ParametersWithID((CipherParameters)new SM2KeyExchangePrivateParameters(isInitiator, aPriv, aePriv), Strings.toByteArray((String)selfid)));
        byte[] k = exch.calculateKey(128, (CipherParameters)new ParametersWithID((CipherParameters)new SM2KeyExchangePublicParameters(bPub, bePub), Strings.toByteArray((String)peerid)));
        return EncodeUtil.base64Encode(k);
    }

    public static PrivateKey formatPrivateKey(byte[] priKey) throws Exception {
        PrivateKey key = null;
        if (priKey == null || priKey.length < 32) {
            throw new RuntimeException("priKey length error");
        }
        if (priKey.length == 32 || priKey.length == 33) {
            key = SM2Util.pack2PrivateKey((BigInteger)new BigInteger(1, priKey));
        } else if (priKey[0] == 48) {
            try {
                key = KeyFactory.getInstance(SM2, PROVIDER).generatePrivate(new PKCS8EncodedKeySpec(priKey));
            }
            catch (InvalidKeySpecException e) {
                ASN1Sequence asn1sqc = ASN1Sequence.getInstance((Object)priKey);
                DEROctetString derKey = (DEROctetString)asn1sqc.getObjectAt(1);
                BigInteger d = BigIntegerUtil.toPositiveInteger((byte[])derKey.getOctets());
                key = SM2Util.pack2PrivateKey((BigInteger)d);
            }
        } else {
            throw new RuntimeException("PrivateKey format not supported");
        }
        return key;
    }

    public static PublicKey formatPublicKey(byte[] pub) throws Exception {
        PublicKey pubKey = null;
        if (pub == null || pub.length < 64) {
            throw new RuntimeException("pubkey length error");
        }
        if (pub.length == 64) {
            byte[] bPoint = new byte[65];
            bPoint[0] = 4;
            System.arraycopy(pub, 0, bPoint, 1, 64);
            pubKey = SM2Util.pack2PublicKey((ECPoint)SM2Util.pack2Point((byte[])bPoint));
        } else if (pub.length == 65 && pub[0] == 4) {
            pubKey = SM2Util.pack2PublicKey((ECPoint)SM2Util.pack2Point((byte[])pub));
        } else if (pub.length > 65 && pub[0] == 48) {
            pubKey = KeyFactory.getInstance(SM2, PROVIDER).generatePublic(new X509EncodedKeySpec(pub));
        } else {
            throw new RuntimeException("PublicKey format not supported");
        }
        return pubKey;
    }
}

