/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj.cryptoutil;

import cn.com.infosec.isfj.Config;
import cn.com.infosec.isfj.enums.BlockCipherModeEnum;
import cn.com.infosec.isfj.enums.PaddingMethodEnum;
import cn.com.infosec.isfj.enums.SymmetricAlgorithm;
import cn.com.infosec.isfj.formatutil.EncodeUtil;
import cn.com.infosec.jcajce.spec.AEADParameterSpec;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SymKeyUtil {
    private static String PROVIDER = Config.getProviderName();

    public static String genSymmetricKey(SymmetricAlgorithm alg, int keyLen) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(alg.getValue(), PROVIDER);
        kg.init(keyLen);
        SecretKey key = kg.generateKey();
        return EncodeUtil.base64Encode(key.getEncoded());
    }

    public static String CMAC(String key, String data, SymmetricAlgorithm alg) {
        String transformation = alg.getValue() + "CMAC";
        SecretKeySpec sk = new SecretKeySpec(EncodeUtil.base64Decode(key), alg.getValue());
        byte[] plain = EncodeUtil.base64Decode(data);
        return SymKeyUtil.clcaCmac(sk, plain, transformation);
    }

    public static String CMAC(byte[] key, byte[] data, SymmetricAlgorithm alg) {
        String transformation = alg.getValue() + "CMAC";
        SecretKeySpec sk = new SecretKeySpec(key, alg.getValue());
        return SymKeyUtil.clcaCmac(sk, data, transformation);
    }

    private static String clcaCmac(Key key, byte[] data, String transformation) {
        Mac mac = null;
        byte[] tTemp = null;
        try {
            mac = Mac.getInstance(transformation, PROVIDER);
            mac.init(key);
            tTemp = mac.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return EncodeUtil.base64Encode(tTemp);
    }

    public static String symmetricCrypt(String key, String data, String iv, String aad, int tagBitSize, SymmetricAlgorithm alg, BlockCipherModeEnum bcm, PaddingMethodEnum pm, boolean isEnc) {
        String transformation = alg.getValue() + "/" + bcm.getValue() + "/" + pm.getValue();
        SecretKeySpec sk = new SecretKeySpec(EncodeUtil.base64Decode(key), alg.getValue());
        byte[] plain = EncodeUtil.base64Decode(data);
        byte[] biv = null;
        byte[] baad = null;
        if (bcm.name().equalsIgnoreCase("CBC") || bcm.name().equalsIgnoreCase("CTR") || bcm.name().equalsIgnoreCase("GCM") || bcm.name().equalsIgnoreCase("OFB")) {
            if (iv == null || iv.length() == 0) {
                throw new RuntimeException(bcm.getValue() + " mode iv can not be null");
            }
            biv = EncodeUtil.base64Decode(iv);
            if (bcm.name().equalsIgnoreCase("GCM")) {
                if (aad != null && !aad.isEmpty()) {
                    baad = EncodeUtil.base64Decode(aad);
                }
                if (tagBitSize < 32 || tagBitSize > 128 || tagBitSize % 8 != 0) {
                    throw new RuntimeException("Invalid value for MAC size: " + tagBitSize);
                }
            }
        }
        if (isEnc) {
            return SymKeyUtil.encrypt(sk, plain, biv, baad, tagBitSize, transformation);
        }
        return SymKeyUtil.decrypt(sk, plain, biv, baad, tagBitSize, transformation);
    }

    public static String SM4_ANSIX919_MAC(String key, String data) {
        byte[] paddingPlain;
        int length;
        if (key == null || data == null || key.length() == 0 || data.length() == 0) {
            return null;
        }
        int GROUP_SIZE = 16;
        BlockCipherModeEnum bcm = BlockCipherModeEnum.CBC;
        PaddingMethodEnum pm = PaddingMethodEnum.NoPadding;
        SymmetricAlgorithm alg = SymmetricAlgorithm.SM4;
        String transformation = alg.getValue() + "/" + bcm.getValue() + "/" + pm.getValue();
        byte[] plain = EncodeUtil.base64Decode(data);
        byte[] iv = new byte[16];
        SecretKeySpec sk = new SecretKeySpec(EncodeUtil.base64Decode(key), alg.getValue());
        int remainder = plain.length % GROUP_SIZE;
        if (remainder == 0) {
            length = plain.length;
            paddingPlain = plain;
        } else {
            length = plain.length + GROUP_SIZE - remainder;
            paddingPlain = new byte[length];
            System.arraycopy(plain, 0, paddingPlain, 0, plain.length);
        }
        byte[] tmpdata = new byte[GROUP_SIZE];
        String cipher = null;
        for (int i = 0; i < length / GROUP_SIZE; ++i) {
            byte[] group = new byte[GROUP_SIZE];
            System.arraycopy(paddingPlain, i * GROUP_SIZE, group, 0, GROUP_SIZE);
            for (int j = 0; j < GROUP_SIZE; ++j) {
                int n = j;
                group[n] = (byte)(group[n] ^ tmpdata[j]);
            }
            cipher = SymKeyUtil.encrypt(sk, group, iv, null, 0, transformation);
            tmpdata = EncodeUtil.base64Decode(cipher);
        }
        return cipher;
    }

    private static String encrypt(Key key, byte[] data, byte[] iv, byte[] aad, int tagBitSize, String transformation) {
        byte[] ciphertext;
        try {
            Cipher cipher = Cipher.getInstance(transformation, PROVIDER);
            if (transformation.contains("CBC") || transformation.contains("CTR") || transformation.contains("GCM") || transformation.contains("OFB")) {
                if (transformation.contains("GCM") && (aad != null || tagBitSize != 0)) {
                    cipher.init(1, key, (AlgorithmParameterSpec)new AEADParameterSpec(iv, tagBitSize, aad));
                } else {
                    cipher.init(1, key, new IvParameterSpec(iv));
                }
            } else {
                cipher.init(1, key);
            }
            ciphertext = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return EncodeUtil.base64Encode(ciphertext);
    }

    private static String decrypt(Key key, byte[] data, byte[] iv, byte[] aad, int tagBitSize, String transformation) {
        byte[] plaintext;
        try {
            Cipher cipher = Cipher.getInstance(transformation, PROVIDER);
            if (transformation.contains("CBC") || transformation.contains("CTR") || transformation.contains("GCM") || transformation.contains("OFB")) {
                if (transformation.contains("GCM") && (aad != null || tagBitSize != 0)) {
                    cipher.init(2, key, (AlgorithmParameterSpec)new AEADParameterSpec(iv, tagBitSize, aad));
                } else {
                    cipher.init(2, key, new IvParameterSpec(iv));
                }
            } else {
                cipher.init(2, key);
            }
            plaintext = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return EncodeUtil.base64Encode(plaintext);
    }
}

