/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.lastchange;

import java.util.ArrayList;
import java.util.Collection;
import org.fourthline.cling.model.DefaultServiceManager;
import org.fourthline.cling.model.meta.LocalService;
import org.fourthline.cling.model.meta.StateVariable;
import org.fourthline.cling.model.state.StateVariableValue;
import org.fourthline.cling.model.types.UnsignedIntegerFourBytes;
import org.fourthline.cling.support.lastchange.LastChange;
import org.fourthline.cling.support.lastchange.LastChangeDelegator;
import org.fourthline.cling.support.lastchange.LastChangeParser;

public class LastChangeAwareServiceManager<T extends LastChangeDelegator>
extends DefaultServiceManager<T> {
    protected final LastChangeParser lastChangeParser;

    public LastChangeAwareServiceManager(LocalService<T> localService, LastChangeParser lastChangeParser) {
        this(localService, null, lastChangeParser);
    }

    public LastChangeAwareServiceManager(LocalService<T> localService, Class<T> serviceClass, LastChangeParser lastChangeParser) {
        super(localService, serviceClass);
        this.lastChangeParser = lastChangeParser;
    }

    protected LastChangeParser getLastChangeParser() {
        return this.lastChangeParser;
    }

    public void fireLastChange() {
        this.lock();
        try {
            ((LastChangeDelegator)this.getImplementation()).getLastChange().fire(this.getPropertyChangeSupport());
        }
        finally {
            this.unlock();
        }
    }

    protected Collection<StateVariableValue> readInitialEventedStateVariableValues() throws Exception {
        LastChange lc = new LastChange(this.getLastChangeParser());
        UnsignedIntegerFourBytes[] ids = ((LastChangeDelegator)this.getImplementation()).getCurrentInstanceIds();
        if (ids.length > 0) {
            for (UnsignedIntegerFourBytes instanceId : ids) {
                ((LastChangeDelegator)this.getImplementation()).appendCurrentState(lc, instanceId);
            }
        } else {
            ((LastChangeDelegator)this.getImplementation()).appendCurrentState(lc, new UnsignedIntegerFourBytes(0L));
        }
        StateVariable variable = this.getService().getStateVariable("LastChange");
        ArrayList<StateVariableValue> values = new ArrayList<StateVariableValue>();
        values.add(new StateVariableValue(variable, (Object)lc.toString()));
        return values;
    }
}

