/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.shared.log.impl;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import org.fourthline.cling.support.shared.TextExpand;
import org.fourthline.cling.support.shared.log.LogView;
import org.seamless.swing.logging.LogMessage;

@ApplicationScoped
public class LogPresenter
implements LogView.Presenter {
    @Inject
    protected LogView view;
    @Inject
    protected Event<TextExpand> textExpandEvent;

    @Override
    public void init() {
        this.view.setPresenter(this);
    }

    @Override
    public void onExpand(LogMessage logMessage) {
        this.textExpandEvent.fire((Object)new TextExpand(logMessage.getMessage()));
    }

    @PreDestroy
    public void destroy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogPresenter.this.view.dispose();
            }
        });
    }

    @Override
    public void pushMessage(final LogMessage message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogPresenter.this.view.pushMessage(message);
            }
        });
    }
}

