/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.sign;

import com.taobao.api.ApiException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoClient;
import com.taobao.api.internal.sign.AliyunUserGetRequest;
import com.taobao.api.internal.sign.AliyunUserGetResponse;
import com.taobao.api.internal.sign.SignCheckDO;
import com.taobao.api.internal.sign.SignUtils;
import com.taobao.api.internal.sign.SignatureValidateRequest;
import com.taobao.api.internal.sign.SignatureValidateResponse;
import com.taobao.api.internal.util.DESUtil;
import com.taobao.api.internal.util.json.ExceptionErrorListener;
import com.taobao.api.internal.util.json.JSONReader;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.LinkedHashMap;
import java.util.Map;

public class SignatureCheckClient {
    private TaobaoClient taobaoClient;
    private Map<String, SignCheckDO> secretCacheMap = new LinkedHashMap<String, SignCheckDO>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SignCheckDO> eldest) {
            return this.size() > 32768;
        }
    };
    private Map<Long, String> accountCacheMap = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, String> eldest) {
            return this.size() > 32768;
        }
    };

    public SignatureCheckClient(TaobaoClient taobaoClient) {
        this.taobaoClient = taobaoClient;
    }

    public boolean checkApiRequestSign(String appKey, byte[] body, String signature, String algorithm, String charset) {
        if (!this.checkParams(appKey, body, signature)) {
            return false;
        }
        try {
            SignatureValidateResponse response = this.invokeRemote(appKey, body, algorithm, signature, charset);
            if (response.isSuccess() && response.getValid() != null && response.getValid().booleanValue()) {
                if (response.getSecret() != null && response.getSecret().length() > 0) {
                    this.secretCacheMap.put(appKey, new SignCheckDO(DESUtil.decrypt(response.getSecret(), signature.substring(0, 8)), response.getIsvId()));
                }
                return true;
            }
            return false;
        }
        catch (ApiException e) {
            return true;
        }
    }

    public boolean checkApiRequestSignWithCache(String appKey, byte[] body, String signature, String algorithm, String charset) {
        String topSignature;
        if (!this.checkParams(appKey, body, signature)) {
            return false;
        }
        SignCheckDO signCheckDO = this.secretCacheMap.get(appKey);
        if (signCheckDO != null && (topSignature = SignUtils.signAndBase64Encode(body, signCheckDO.getSecret(), algorithm, charset)).equals(signature)) {
            return true;
        }
        return this.checkApiRequestSign(appKey, body, signature, algorithm, charset);
    }

    private boolean checkParams(String appKey, byte[] body, String signature) {
        if (appKey == null || appKey.length() == 0) {
            return false;
        }
        if (signature == null || signature.length() == 0) {
            return false;
        }
        return body != null && body.length != 0;
    }

    public SignCheckDO removeCahceSignCheckInfo(String appKey) {
        return this.secretCacheMap.remove(appKey);
    }

    public Long getIsvId(String appKey) {
        SignCheckDO signCheck = this.secretCacheMap.get(appKey);
        if (signCheck != null) {
            return signCheck.getIsvId();
        }
        return null;
    }

    public String getAliyunUserId(String appKey) {
        SignCheckDO signCheck = this.secretCacheMap.get(appKey);
        if (signCheck != null) {
            return this.getAliyunUserId(signCheck.getIsvId());
        }
        return null;
    }

    public String getAliyunUserId(Long isvId) {
        String account = this.accountCacheMap.get(isvId);
        if (account == null && (account = this.invokeRemoteGetAliyunUserId(isvId)) != null) {
            this.accountCacheMap.put(isvId, account);
        }
        return account;
    }

    private String invokeRemoteGetAliyunUserId(long userId) {
        try {
            JSONValidatingReader reader;
            Map rootObj;
            String acountJson;
            AliyunUserGetRequest request = new AliyunUserGetRequest();
            request.setUserId(userId);
            AliyunUserGetResponse response = this.taobaoClient.execute(request);
            if (response.isSuccess() && (acountJson = response.getAccount()) != null && (rootObj = (Map)((JSONReader)(reader = new JSONValidatingReader(new ExceptionErrorListener()))).read(acountJson)) != null) {
                return rootObj.get("aliyunPK").toString();
            }
        }
        catch (ApiException apiException) {
            // empty catch block
        }
        return null;
    }

    public void removeAllCacheInfo() {
        this.secretCacheMap.clear();
    }

    public SignatureValidateResponse invokeRemote(String appKey, byte[] body, String algorithm, String signature, String charset) throws ApiException {
        SignatureValidateRequest request = new SignatureValidateRequest();
        request.setAlgorithm(algorithm);
        request.setSignature(signature);
        request.setCharset(charset);
        request.setBody(new FileItem("body", body));
        request.setProxyAppKey(appKey);
        return this.taobaoClient.execute(request);
    }
}

