/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.mapping;

import com.qimen.api.QimenResponse;
import com.qimencloud.api.QimenCloudResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.internal.mapping.DingTalkErrorField;
import com.taobao.api.internal.mapping.QimenErrorField;
import com.taobao.api.internal.mapping.Reader;
import com.taobao.api.internal.mapping.TopErrorField;
import com.taobao.api.internal.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Object emptyCache = new Object();
    private static final Map<String, Set<String>> baseProps = new HashMap<String, Set<String>>();
    private static final Map<String, Object> fieldCache = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> methodCache = new ConcurrentHashMap<String, Object>();

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader, String responseType) throws ApiException {
        T rsp = null;
        try {
            PropertyDescriptor[] pds;
            rsp = clazz.newInstance();
            Field successField = null;
            Field[] successFields = clazz.getDeclaredFields();
            if (successFields != null && successFields.length > 0) {
                for (Field field : successFields) {
                    if (!field.getName().equals("success")) continue;
                    successField = field;
                }
            }
            Method successMethod = null;
            Method[] methods = clazz.getMethods();
            if (methods != null && methods.length > 0) {
                for (Method method : methods) {
                    if (!method.getName().equals("setSuccess")) continue;
                    successMethod = method;
                }
            }
            if (successField != null && successMethod != null) {
                ApiListField jsonListField;
                String successItemName = successField.getName();
                String successListName = null;
                ApiField jsonField = successField.getAnnotation(ApiField.class);
                if (jsonField != null) {
                    successItemName = jsonField.value();
                }
                if ((jsonListField = successField.getAnnotation(ApiListField.class)) != null) {
                    successListName = jsonListField.value();
                }
                if (reader.hasReturnField(successItemName) || successListName == null || !reader.hasReturnField(successListName)) {
                    // empty if block
                }
                Converters.setMethodValue(rsp, reader, successItemName, successListName, successField, successMethod);
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                ApiListField jsonListField;
                Annotation jsonField;
                Method method = Converters.getCacheMethod(clazz, pd);
                if (method == null) continue;
                String itemName = pd.getName();
                String listName = null;
                Field field = null;
                boolean isErrorParam = false;
                if ((TaobaoResponse.class.isAssignableFrom(clazz) || QimenCloudResponse.class.isAssignableFrom(clazz) || QimenResponse.class.isAssignableFrom(clazz)) && clazz.getSuperclass().getName().equals("java.lang.Object")) {
                    isErrorParam = true;
                    field = Converters.getField(clazz, pd);
                } else {
                    Set<String> stopProps = baseProps.get(clazz.getSuperclass().getName());
                    if (stopProps != null && stopProps.contains(itemName)) {
                        isErrorParam = true;
                        field = Converters.getField(clazz.getSuperclass(), pd);
                    } else {
                        field = Converters.getField(clazz, pd);
                    }
                }
                if (field == null) continue;
                if (isErrorParam) {
                    if (null == responseType || "top".equals(responseType)) {
                        jsonField = field.getAnnotation(TopErrorField.class);
                        if (jsonField == null) continue;
                        itemName = jsonField.value();
                        Converters.setMethodValue(rsp, reader, itemName, listName, field, method);
                        continue;
                    }
                    if ("qimen1".equals(responseType) || "qimen2".equals(responseType)) {
                        jsonField = field.getAnnotation(QimenErrorField.class);
                        if (jsonField == null) continue;
                        itemName = jsonField.value();
                        Converters.setMethodValue(rsp, reader, itemName, listName, field, method);
                        continue;
                    }
                    if (!"dingtalk".equals(responseType) || (jsonField = field.getAnnotation(DingTalkErrorField.class)) == null) continue;
                    itemName = jsonField.value();
                    Converters.setMethodValue(rsp, reader, itemName, listName, field, method);
                    continue;
                }
                jsonField = field.getAnnotation(ApiField.class);
                if (jsonField != null) {
                    itemName = jsonField.value();
                }
                if ((jsonListField = field.getAnnotation(ApiListField.class)) != null) {
                    listName = jsonListField.value();
                }
                if (!reader.hasReturnField(itemName) && (listName == null || !reader.hasReturnField(listName))) continue;
                Converters.setMethodValue(rsp, reader, itemName, listName, field, method);
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return rsp;
    }

    public static Field getField(Class<?> clazz, PropertyDescriptor pd) throws Exception {
        String key = clazz.getName() + "_" + pd.getName();
        Object field = fieldCache.get(key);
        if (field == null) {
            try {
                field = clazz.getDeclaredField(pd.getName());
            }
            catch (NoSuchFieldException e) {
                Class<?> superClazz = clazz.getSuperclass();
                if (!superClazz.getName().equals("java.lang.Object")) {
                    try {
                        field = superClazz.getDeclaredField(pd.getName());
                    }
                    catch (NoSuchFieldException e1) {
                        field = emptyCache;
                    }
                }
                field = emptyCache;
            }
            fieldCache.put(key, field);
        }
        return field == emptyCache ? null : (Field)field;
    }

    private static Method getCacheMethod(Class<?> clazz, PropertyDescriptor pd) {
        String key = clazz.getName() + "_" + pd.getName();
        Object method = methodCache.get(key);
        if (method == null) {
            method = pd.getWriteMethod();
            if (method == null) {
                method = emptyCache;
            }
            methodCache.put(key, method);
        }
        return method == emptyCache ? null : (Method)method;
    }

    private static <T> void setMethodValue(T rsp, Reader reader, String itemName, String listName, Field field, Method method) throws Exception {
        Class<?> typeClass = field.getType();
        if (String.class.isAssignableFrom(typeClass)) {
            Object value = reader.getPrimitiveObject(itemName);
            if (value instanceof String) {
                method.invoke(rsp, value.toString());
            } else {
                if (isCheckJsonType && value != null) {
                    throw new ApiException(itemName + " is not a String");
                }
                if (value != null) {
                    method.invoke(rsp, value.toString());
                } else {
                    method.invoke(rsp, "");
                }
            }
        } else if (Long.class.isAssignableFrom(typeClass)) {
            Object value = reader.getPrimitiveObject(itemName);
            if (value instanceof Long) {
                method.invoke(rsp, (Long)value);
            } else {
                if (isCheckJsonType && value != null) {
                    throw new ApiException(itemName + " is not a Number(Long)");
                }
                if (StringUtils.isNumeric(value)) {
                    method.invoke(rsp, Long.valueOf(value.toString()));
                }
            }
        } else if (Boolean.class.isAssignableFrom(typeClass)) {
            Object value = reader.getPrimitiveObject(itemName);
            if (value instanceof Boolean) {
                method.invoke(rsp, (Boolean)value);
            } else {
                if (isCheckJsonType && value != null) {
                    throw new ApiException(itemName + " is not a Boolean");
                }
                if (value != null) {
                    method.invoke(rsp, Boolean.valueOf(value.toString()));
                }
            }
        } else if (Date.class.isAssignableFrom(typeClass)) {
            Object value = reader.getPrimitiveObject(itemName);
            if (value instanceof String) {
                method.invoke(rsp, StringUtils.parseDateTime(value.toString()));
            } else if (value instanceof Long) {
                method.invoke(rsp, new Date((Long)value));
            }
        } else if (List.class.isAssignableFrom(typeClass)) {
            Class subType;
            List<?> listObjs;
            ParameterizedType paramType;
            Type[] genericTypes;
            Type fieldType = field.getGenericType();
            if (fieldType instanceof ParameterizedType && (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) != null && genericTypes.length > 0 && genericTypes[0] instanceof Class && (listObjs = reader.getListObjects(listName, itemName, subType = (Class)genericTypes[0])) != null) {
                method.invoke(rsp, listObjs);
            }
        } else if (Integer.class.isAssignableFrom(typeClass)) {
            Object value = reader.getPrimitiveObject(itemName);
            if (value instanceof Integer) {
                method.invoke(rsp, (Integer)value);
            } else {
                if (isCheckJsonType && value != null) {
                    throw new ApiException(itemName + " is not a Number(Integer)");
                }
                if (StringUtils.isNumeric(value)) {
                    method.invoke(rsp, Integer.valueOf(value.toString()));
                }
            }
        } else if (Double.class.isAssignableFrom(typeClass)) {
            Object value = reader.getPrimitiveObject(itemName);
            if (value instanceof Double) {
                method.invoke(rsp, (Double)value);
            } else if (isCheckJsonType && value != null) {
                throw new ApiException(itemName + " is not a Double");
            }
        } else if (Number.class.isAssignableFrom(typeClass)) {
            Object value = reader.getPrimitiveObject(itemName);
            if (value instanceof Number) {
                method.invoke(rsp, (Number)value);
            } else if (isCheckJsonType && value != null) {
                throw new ApiException(itemName + " is not a Number");
            }
        } else {
            Object obj = reader.getObject(itemName, typeClass);
            if (obj != null) {
                method.invoke(rsp, obj);
            }
        }
    }

    static {
        baseProps.put(TaobaoResponse.class.getName(), StringUtils.getClassProperties(TaobaoResponse.class, false));
        baseProps.put(QimenResponse.class.getName(), StringUtils.getClassProperties(QimenResponse.class, false));
    }
}

