/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.spi;

import com.taobao.api.internal.spi.CheckResult;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiUtils {
    private static final Log log = LogFactory.getLog(SpiUtils.class);
    private static final String TOP_SIGN_LIST = "top-sign-list";
    private static final String[] HEADER_FIELDS_IP = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    public static CheckResult checkSign(HttpServletRequest request, String secret) throws IOException {
        CheckResult result = new CheckResult();
        String ctype = request.getContentType();
        String charset = WebUtils.getResponseCharset(ctype);
        if (ctype.startsWith("application/json") || ctype.startsWith("text/xml") || ctype.startsWith("application/xml") || ctype.startsWith("text/plain")) {
            String body = WebUtils.getStreamAsString((InputStream)request.getInputStream(), charset);
            boolean valid = SpiUtils.checkSignInternal(request, null, body, secret, charset);
            result.setSuccess(valid);
            result.setRequestBody(body);
        } else if (ctype.startsWith("application/x-www-form-urlencoded")) {
            boolean valid = SpiUtils.checkSignInternal(request, null, null, secret, charset);
            result.setSuccess(valid);
        } else {
            throw new RuntimeException("Unspported SPI request");
        }
        return result;
    }

    public static boolean checkSign4FormRequest(HttpServletRequest request, String secret) throws IOException {
        String charset = WebUtils.getResponseCharset(request.getContentType());
        return SpiUtils.checkSignInternal(request, null, null, secret, charset);
    }

    public static boolean checkSign4TextRequest(HttpServletRequest request, String body, String secret) throws IOException {
        String charset = WebUtils.getResponseCharset(request.getContentType());
        return SpiUtils.checkSignInternal(request, null, body, secret, charset);
    }

    public static boolean checkSign4FileRequest(HttpServletRequest request, Map<String, String> form, String secret) throws IOException {
        String charset = WebUtils.getResponseCharset(request.getContentType());
        return SpiUtils.checkSignInternal(request, form, null, secret, charset);
    }

    private static boolean checkSignInternal(HttpServletRequest request, Map<String, String> form, String body, String secret, String charset) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        Map<String, String> headerMap = SpiUtils.getHeaderMap(request, charset);
        params.putAll(headerMap);
        Map<String, String> queryMap = SpiUtils.getQueryMap(request, charset);
        params.putAll(queryMap);
        if (form == null && body == null) {
            Map<String, String> formMap = SpiUtils.getFormMap(request, queryMap);
            params.putAll(formMap);
        } else if (form != null) {
            params.putAll(form);
        }
        String remoteSign = queryMap.get("sign");
        String localSign = SpiUtils.sign(params, body, secret, charset);
        if (localSign.equals(remoteSign)) {
            return true;
        }
        String paramStr = SpiUtils.getParamStrFromMap(params);
        log.error((Object)("checkTopSign error^_^remoteSign=" + remoteSign + "^_^localSign=" + localSign + "^_^paramStr=" + paramStr + "^_^body=" + body));
        return false;
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request, String charset) throws IOException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String signList = request.getHeader(TOP_SIGN_LIST);
        if (!StringUtils.isEmpty(signList)) {
            String[] keys;
            for (String key : keys = signList.split(",")) {
                String value = request.getHeader(key);
                if (StringUtils.isEmpty(value)) {
                    headerMap.put(key, "");
                    continue;
                }
                headerMap.put(key, URLDecoder.decode(value, charset));
            }
        }
        return headerMap;
    }

    public static Map<String, String> getQueryMap(HttpServletRequest request, String charset) throws IOException {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        String queryString = request.getQueryString();
        String[] params = queryString.split("&");
        for (int i = 0; i < params.length; ++i) {
            String key;
            String[] kv = params[i].split("=");
            if (kv.length == 2) {
                key = URLDecoder.decode(kv[0], charset);
                String value = URLDecoder.decode(kv[1], charset);
                queryMap.put(key, value);
                continue;
            }
            if (kv.length != 1) continue;
            key = URLDecoder.decode(kv[0], charset);
            queryMap.put(key, "");
        }
        return queryMap;
    }

    public static Map<String, String> getFormMap(HttpServletRequest request, Map<String, String> queryMap) throws IOException {
        HashMap<String, String> formMap = new HashMap<String, String>();
        Set keys = request.getParameterMap().keySet();
        for (Object tmp : keys) {
            String key = String.valueOf(tmp);
            if (queryMap.containsKey(key)) continue;
            String value = request.getParameter(key);
            if (StringUtils.isEmpty(value)) {
                formMap.put(key, "");
                continue;
            }
            formMap.put(key, value);
        }
        return formMap;
    }

    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        return WebUtils.getStreamAsString(stream, charset);
    }

    private static String sign(Map<String, String> params, String body, String secret, String charset) throws IOException {
        StringBuilder sb = new StringBuilder(secret);
        sb.append(SpiUtils.getParamStrFromMap(params));
        if (body != null) {
            sb.append(body);
        }
        sb.append(secret);
        byte[] bytes = TaobaoUtils.encryptMD5(sb.toString().getBytes(charset));
        return TaobaoUtils.byte2hex(bytes);
    }

    private static String getParamStrFromMap(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            Object[] keys = params.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                Object name = keys[i];
                if ("sign".equals(name)) continue;
                sb.append((String)name);
                sb.append(params.get(name));
            }
        }
        return sb.toString();
    }

    public static boolean checkTimestamp(HttpServletRequest request, int minutes) {
        String ts = request.getParameter("timestamp");
        if (ts != null) {
            long remote = StringUtils.parseDateTime(ts).getTime();
            long local = Calendar.getInstance().getTime().getTime();
            return local - remote <= (long)(minutes * 60) * 1000L;
        }
        return false;
    }

    public static boolean checkRemoteIp(HttpServletRequest request, List<String> topIpList) {
        String ip = request.getRemoteAddr();
        for (String ipHeader : HEADER_FIELDS_IP) {
            String realIp = request.getHeader(ipHeader);
            if (StringUtils.isEmpty(realIp) || "unknown".equalsIgnoreCase(realIp)) continue;
            ip = realIp;
            break;
        }
        if (topIpList != null) {
            for (String topIp : topIpList) {
                if (!StringUtils.isIpInRange(ip, topIp)) continue;
                return true;
            }
        }
        return false;
    }
}

