/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.cluster;

import com.taobao.api.internal.cluster.ApiConfig;
import com.taobao.api.internal.cluster.ApiModle;
import com.taobao.api.internal.cluster.ApiRule;
import com.taobao.api.internal.cluster.ClusterManager;
import com.taobao.api.internal.cluster.EnvConfig;
import com.taobao.api.internal.cluster.VipRule;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsConfig {
    private Map<String, String> globalMap;
    private Map<String, Integer> modleMap;
    private Map<String, ApiConfig> apiMap;
    private Map<String, List<EnvConfig>> envMap;
    private Map<String, Map<String, String>> userMap;

    public static DnsConfig parse(String json) {
        DnsConfig dnsConfig = new DnsConfig();
        Map root = (Map)TaobaoUtils.jsonToObject(json);
        for (Object configType : root.keySet()) {
            if ("config".equals(configType)) {
                dnsConfig.globalMap = new HashMap<String, String>();
                Map globalInfo = (Map)root.get(configType);
                for (Object key : globalInfo.keySet()) {
                    dnsConfig.globalMap.put(String.valueOf(key), String.valueOf(globalInfo.get(key)));
                }
                continue;
            }
            if ("env".equals(configType)) {
                Map envInfos = (Map)root.get(configType);
                dnsConfig.envMap = new HashMap<String, List<EnvConfig>>();
                for (Object envName : envInfos.keySet()) {
                    Map envInfo = (Map)envInfos.get(envName);
                    ArrayList<EnvConfig> envConfigs = new ArrayList<EnvConfig>();
                    for (Object domainName : envInfo.keySet()) {
                        Map domainInfo = (Map)envInfo.get(domainName);
                        EnvConfig envConfig = new EnvConfig();
                        envConfig.setDomain(String.valueOf(domainName));
                        envConfig.setProtocol(String.valueOf(domainInfo.get("proto")));
                        List vipInfos = (List)domainInfo.get("vip");
                        ArrayList<VipRule> vipRules = new ArrayList<VipRule>();
                        for (Object vipInfo : vipInfos) {
                            String[] vipInfoTmp = vipInfo.toString().split("\\|");
                            VipRule vipRule = new VipRule();
                            vipRule.setVip(vipInfoTmp[0]);
                            vipRule.setWeight(Double.parseDouble(vipInfoTmp[1]));
                            vipRules.add(vipRule);
                        }
                        envConfig.setVipRules(vipRules);
                        envConfigs.add(envConfig);
                    }
                    dnsConfig.envMap.put(String.valueOf(envName), envConfigs);
                }
                continue;
            }
            if ("api".equals(configType)) {
                dnsConfig.apiMap = new HashMap<String, ApiConfig>();
                Map apiInfos = (Map)root.get(configType);
                for (Object apiName : apiInfos.keySet()) {
                    Map apiInfo = (Map)apiInfos.get(apiName);
                    ApiConfig apiConfig = new ApiConfig();
                    apiConfig.setUser(String.valueOf(apiInfo.get("user")));
                    if (apiInfo.get("modle") != null) {
                        ApiModle apiModle = new ApiModle();
                        String modle = String.valueOf(apiInfo.get("modle"));
                        apiModle.setField(modle.split("\\|")[1]);
                        apiModle.setModle(modle.split("\\|")[0]);
                        apiConfig.setModle(apiModle);
                    }
                    ArrayList<ApiRule> apiRules = new ArrayList<ApiRule>();
                    List apiRuleInfos = (List)apiInfo.get("rule");
                    for (Object apiRuleInfo : apiRuleInfos) {
                        String[] apiRuleInfoTmp = apiRuleInfo.toString().split("\\|");
                        ApiRule apiRule = new ApiRule();
                        apiRule.setName(apiRuleInfoTmp[0]);
                        apiRule.setWeight(Double.parseDouble(apiRuleInfoTmp[1]));
                        apiRules.add(apiRule);
                    }
                    apiConfig.setRules(apiRules);
                    dnsConfig.apiMap.put(String.valueOf(apiName), apiConfig);
                }
                continue;
            }
            if ("user".equals(configType)) {
                dnsConfig.userMap = new HashMap<String, Map<String, String>>();
                Map userInfos = (Map)root.get(configType);
                for (Object routeName : userInfos.keySet()) {
                    Map envInfos = (Map)userInfos.get(routeName);
                    HashMap<String, String> tags = new HashMap<String, String>();
                    for (Object envName : envInfos.keySet()) {
                        List tagInfos = (List)envInfos.get(envName);
                        for (Object tagName : tagInfos) {
                            tags.put(String.valueOf(tagName), String.valueOf(envName));
                        }
                    }
                    dnsConfig.userMap.put(String.valueOf(routeName), tags);
                }
                continue;
            }
            if (!"modle".equals(configType)) continue;
            dnsConfig.modleMap = new HashMap<String, Integer>();
            Map modleInfo = (Map)root.get(configType);
            for (Object key : modleInfo.keySet()) {
                dnsConfig.modleMap.put(String.valueOf(key), Integer.parseInt(modleInfo.get(key).toString()));
            }
        }
        return dnsConfig;
    }

    public String getBestVipUrl(String serverUrl, String apiName, String session, TaobaoHashMap appParams) {
        if (this.apiMap.containsKey(apiName)) {
            String userEnv;
            Map<String, String> userEnvs;
            ApiConfig apiConfig = this.apiMap.get(apiName);
            String flag = null;
            if (!StringUtils.isEmpty(session) && apiConfig.getUser() != null && apiConfig.getModle() == null) {
                flag = this.getUserFlag(session);
            }
            if (apiConfig.getUser() != null && apiConfig.getModle() != null) {
                flag = this.getModleFlag(apiConfig, appParams);
            }
            if (flag != null && this.userMap.containsKey(apiConfig.getUser()) && (userEnvs = this.userMap.get(apiConfig.getUser())).containsKey(flag) && this.envMap.containsKey(userEnv = userEnvs.get(flag))) {
                List<EnvConfig> envConfigs = this.envMap.get(userEnv);
                return this.getEnvVipUrl(serverUrl, envConfigs);
            }
            return this.getApiVipUrl(serverUrl, apiConfig);
        }
        List<EnvConfig> envConfigs = this.envMap.get(this.globalMap.get("def_env"));
        return this.getEnvVipUrl(serverUrl, envConfigs);
    }

    private String getModleFlag(ApiConfig apiConfig, TaobaoHashMap appParams) {
        String modle = apiConfig.getModle().getModle();
        String field = apiConfig.getModle().getField();
        if (modle != null && field != null && appParams.containsKey(field)) {
            String value = (String)appParams.get(field);
            Integer modleFalg = this.modleMap.get(modle);
            if (modleFalg < 0) {
                return value.substring(value.length() + modleFalg, value.length() + modleFalg + 1);
            }
            return value.substring(modleFalg, modleFalg + 1);
        }
        return null;
    }

    private String getApiVipUrl(String serverUrl, ApiConfig apiConfig) {
        ApiRule apiRule = ClusterManager.getElementByWeight(apiConfig.getRules());
        if (this.envMap.containsKey(apiRule.getName())) {
            List<EnvConfig> envConfigs = this.envMap.get(apiRule.getName());
            return this.getEnvVipUrl(serverUrl, envConfigs);
        }
        List<EnvConfig> envConfigs = this.envMap.get(this.globalMap.get("def_env"));
        return this.getEnvVipUrl(serverUrl, envConfigs);
    }

    private String getEnvVipUrl(String serverUrl, List<EnvConfig> envConfigs) {
        for (EnvConfig envConfig : envConfigs) {
            try {
                URI uri = new URI(serverUrl);
                if (!uri.getHost().equalsIgnoreCase(envConfig.getDomain()) || !uri.getScheme().equalsIgnoreCase(envConfig.getProtocol())) continue;
                String vip = ClusterManager.getElementByWeight(envConfig.getVipRules()).getVip();
                return serverUrl.replace(envConfig.getDomain(), vip);
            }
            catch (Exception e) {
            }
        }
        return serverUrl;
    }

    private String getUserFlag(String session) {
        if (!StringUtils.isEmpty(session) && session.length() > 5) {
            if (session.startsWith("6") || session.startsWith("7")) {
                return session.substring(session.length() - 1, session.length());
            }
            if (session.startsWith("5") || session.startsWith("8")) {
                return session.substring(5, 6);
            }
        }
        return null;
    }

    public int getRefreshInterval() {
        String tmp = this.globalMap.get("interval");
        if (tmp != null) {
            return Integer.parseInt(tmp);
        }
        return 30;
    }
}

