/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.report;

import com.taobao.api.ApiException;
import com.taobao.api.TaobaoClient;
import com.taobao.api.internal.report.TopSdkFeedbackUploadRequest;
import com.taobao.api.internal.report.TopSdkFeedbackUploadResponse;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.security.SecurityCore;
import com.taobao.api.security.SecurityCounter;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApiReporter {
    private static final Log log = LogFactory.getLog(ApiReporter.class);
    private static final AtomicBoolean initSecretAtomic = new AtomicBoolean(false);
    private static final long FLUSH_INTERVAL = 300000L;
    private static final long MIN_FLUSH_INTERVAL = 60000L;
    private static final String SECRET_TYPE = "1";
    private TaobaoClient taobaoClient;

    public void initSecret(TaobaoClient taobaoClient) {
        this.taobaoClient = taobaoClient;
        if (!initSecretAtomic.get()) {
            this.initSecretThread();
        }
    }

    @Deprecated
    private void initSecretThread() {
        if (initSecretAtomic.compareAndSet(false, true)) {
            new Thread("flushSecretApiReporter-thread"){

                public void run() {
                    long uploadInterval = 300000L;
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(uploadInterval);
                                HashMap<String, Number> jsonMap = new HashMap<String, Number>();
                                jsonMap.put("sessionNum", SecurityCore.getAppUserSecretCache().size());
                                jsonMap.put("encryptPhoneNum", SecurityCounter.getEncryptPhoneNum());
                                jsonMap.put("encryptNickNum", SecurityCounter.getEncryptNickNum());
                                jsonMap.put("encryptReceiverNameNum", SecurityCounter.getEncryptReceiverNameNum());
                                jsonMap.put("decryptPhoneNum", SecurityCounter.getDecryptPhoneNum());
                                jsonMap.put("decryptNickNum", SecurityCounter.getDecryptNickNum());
                                jsonMap.put("decryptReceiverNameNum", SecurityCounter.getDecryptReceiverNameNum());
                                jsonMap.put("searchPhoneNum", SecurityCounter.getSearchPhoneNum());
                                jsonMap.put("searchNickNum", SecurityCounter.getSearchNickNum());
                                jsonMap.put("searchReceiverNameNum", SecurityCounter.getSearchReceiverNameNum());
                                String contentJson = TaobaoUtils.objectToJson(jsonMap);
                                SecurityCounter.reset();
                                uploadInterval = ApiReporter.this.doUpload(contentJson, ApiReporter.SECRET_TYPE);
                            }
                        }
                        catch (Throwable e) {
                            log.error((Object)"flushSecretApiReporter error", e);
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    private long doUpload(String contentJson, String type) throws ApiException {
        long uploadInterval = 300000L;
        TopSdkFeedbackUploadRequest request = new TopSdkFeedbackUploadRequest();
        request.setType(type);
        request.setContent(contentJson);
        TopSdkFeedbackUploadResponse response = this.taobaoClient.execute(request, null);
        if (response.isSuccess() && (uploadInterval = response.getUploadInterval()) < 60000L) {
            uploadInterval = 300000L;
        }
        return uploadInterval;
    }
}

