/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.domain.Text;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.NlpSemanticTextsAnalyzeResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NlpSemanticTextsAnalyzeRequest
extends BaseTaobaoRequest<NlpSemanticTextsAnalyzeResponse> {
    private String texts;
    private String types;

    public void setTexts(String texts) {
        this.texts = texts;
    }

    public void setTexts(List<Text> texts) {
        this.texts = new JSONWriter(false, true).write(texts);
    }

    public String getTexts() {
        return this.texts;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public String getTypes() {
        return this.types;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.nlp.semantic.texts.analyze";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("texts", this.texts);
        txtParams.put("types", this.types);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<NlpSemanticTextsAnalyzeResponse> getResponseClass() {
        return NlpSemanticTextsAnalyzeResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.texts, 50, "texts");
    }
}

