/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.domain.Text;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.NlpWordResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NlpWordRequest
extends BaseTaobaoRequest<NlpWordResponse> {
    private String text;
    private Long wType;

    public void setText(String text) {
        this.text = text;
    }

    public void setText(Text text) {
        this.text = new JSONWriter(false, true).write(text);
    }

    public String getText() {
        return this.text;
    }

    public void setwType(Long wType) {
        this.wType = wType;
    }

    public Long getwType() {
        return this.wType;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.nlp.word";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("text", this.text);
        txtParams.put("w_type", (Object)this.wType);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<NlpWordResponse> getResponseClass() {
        return NlpWordResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.wType, "wType");
    }
}

