/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OpenimChatlogsImportResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenimChatlogsImportRequest
extends BaseTaobaoRequest<OpenimChatlogsImportResponse> {
    private String messages;

    public void setMessages(String messages) {
        this.messages = messages;
    }

    public void setMessages(List<TextMessage> messages) {
        this.messages = new JSONWriter(false, true).write(messages);
    }

    public String getMessages() {
        return this.messages;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.openim.chatlogs.import";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("messages", this.messages);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<OpenimChatlogsImportResponse> getResponseClass() {
        return OpenimChatlogsImportResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.messages, 20, "messages");
    }

    public static class TextMessage
    extends TaobaoObject {
        private static final long serialVersionUID = 1188768567355898261L;
        @ApiField(value="from_id")
        private String fromId;
        @ApiField(value="message")
        private String message;
        @ApiField(value="time")
        private Long time;
        @ApiField(value="to_id")
        private String toId;

        public String getFromId() {
            return this.fromId;
        }

        public void setFromId(String fromId) {
            this.fromId = fromId;
        }

        public void setFromIdString(String fromId) {
            this.fromId = fromId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Long getTime() {
            return this.time;
        }

        public void setTime(Long time) {
            this.time = time;
        }

        public String getToId() {
            return this.toId;
        }

        public void setToId(String toId) {
            this.toId = toId;
        }

        public void setToIdString(String toId) {
            this.toId = toId;
        }
    }
}

