/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OpenimTribelogsImportResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenimTribelogsImportRequest
extends BaseTaobaoRequest<OpenimTribelogsImportResponse> {
    private String messages;
    private Long tribeId;

    public void setMessages(String messages) {
        this.messages = messages;
    }

    public void setMessages(List<TribeTextMessage> messages) {
        this.messages = new JSONWriter(false, true).write(messages);
    }

    public String getMessages() {
        return this.messages;
    }

    public void setTribeId(Long tribeId) {
        this.tribeId = tribeId;
    }

    public Long getTribeId() {
        return this.tribeId;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.openim.tribelogs.import";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("messages", this.messages);
        txtParams.put("tribe_id", (Object)this.tribeId);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<OpenimTribelogsImportResponse> getResponseClass() {
        return OpenimTribelogsImportResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkObjectMaxListSize(this.messages, 20, "messages");
        RequestCheckUtils.checkNotEmpty(this.tribeId, "tribeId");
    }

    public static class TribeTextMessage
    extends TaobaoObject {
        private static final long serialVersionUID = 1525111145671199238L;
        @ApiField(value="from_id")
        private String fromId;
        @ApiField(value="message")
        private String message;
        @ApiField(value="time")
        private Long time;

        public String getFromId() {
            return this.fromId;
        }

        public void setFromId(String fromId) {
            this.fromId = fromId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Long getTime() {
            return this.time;
        }

        public void setTime(Long time) {
            this.time = time;
        }
    }
}

