/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.security;

import com.taobao.api.ApiException;
import com.taobao.api.SecretException;
import com.taobao.api.TaobaoClient;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.security.SecretContext;
import com.taobao.api.security.SecretData;
import com.taobao.api.security.SecurityBiz;
import com.taobao.api.security.SecurityConstants;
import com.taobao.api.security.SecurityCore;
import com.taobao.api.security.SecurityCounter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityClient
implements SecurityConstants {
    private SecurityCore secretCore;

    public SecurityClient(TaobaoClient taobaoClient, String randomNum) {
        this(taobaoClient, randomNum, 2, 8, Integer.MAX_VALUE);
    }

    public SecurityClient(TaobaoClient taobaoClient, String randomNum, int corePoolSize, int maxPoolSize, int maxQueue) {
        this.secretCore = new SecurityCore(taobaoClient, randomNum, corePoolSize, maxPoolSize, maxQueue);
    }

    public void initSecret() throws ApiException {
        this.secretCore.getSecret((String)null, (Long)null);
    }

    public void setRandomNum(String randomNum) {
        this.secretCore.setRandomNum(randomNum);
    }

    public void initSecret(String session) throws ApiException {
        this.secretCore.getSecret(session, (Long)null);
    }

    public Map<String, String> decrypt(List<String> dataList, String type) throws SecretException {
        return this.decrypt(dataList, type, null);
    }

    public Map<String, String> decrypt(List<String> dataList, String type, String session) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            throw new SecretException("dataList can`t be empty");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String data : dataList) {
            if (resultMap.containsKey(data)) continue;
            String decryptValue = this.decrypt(data, type, session);
            resultMap.put(data, decryptValue);
        }
        return resultMap;
    }

    public String decrypt(String data, String type) throws SecretException {
        return this.decrypt(data, type, null);
    }

    public String decrypt(String data, String type, String session) throws SecretException {
        if (StringUtils.isEmpty(data) || data.length() < 4) {
            return data;
        }
        Character charValue = SecurityBiz.getSeparatorCharMap().get(type);
        if (charValue == null) {
            throw new SecretException("type error");
        }
        char separator = charValue.charValue();
        if (data.charAt(0) != separator || data.charAt(data.length() - 1) != separator) {
            return data;
        }
        SecretData secretDataDO = null;
        secretDataDO = data.charAt(data.length() - 2) == separator ? SecurityBiz.getIndexSecretData(data, separator) : SecurityBiz.getSecretData(data, separator);
        if (secretDataDO == null) {
            return data;
        }
        try {
            SecurityCounter.addDecryptCount(type);
            SecretContext secretContextDO = this.secretCore.getSecret(session, secretDataDO.getSecretVersion());
            String decryptValue = TaobaoUtils.aesDecrypt(secretDataDO.getOriginalBase64Value(), secretContextDO.getSecret());
            if ("phone".equals(type) && !secretDataDO.isSearch()) {
                return secretDataDO.getOriginalValue() + decryptValue;
            }
            return decryptValue;
        }
        catch (ApiException e) {
            throw new SecretException("get secret error", e);
        }
    }

    public static boolean isEncryptData(List<String> dataList, String type) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (String data : dataList) {
            result = SecurityClient.isEncryptData(data, type);
            if (result) continue;
            return false;
        }
        return result;
    }

    public static boolean isEncryptData(String data, String type) throws SecretException {
        return SecurityBiz.isEncryptData(data, type);
    }

    public String encrypt(String data, String type) throws SecretException {
        return this.encrypt(data, type, null, null);
    }

    public String encryptPrevious(String data, String type) throws SecretException {
        return this.encrypt(data, type, null, -1L);
    }

    public String encrypt(String data, String type, String session) throws SecretException {
        return this.encrypt(data, type, session, null);
    }

    public String encryptPrevious(String data, String type, String session) throws SecretException {
        return this.encrypt(data, type, session, -1L);
    }

    public String search(String data, String type) throws SecretException {
        return this.search(data, type, null, null);
    }

    public String searchPrevious(String data, String type) throws SecretException {
        return this.search(data, type, null, -1L);
    }

    public String search(String data, String type, String session) throws SecretException {
        return this.search(data, type, session, null);
    }

    public String searchPrevious(String data, String type, String session) throws SecretException {
        return this.search(data, type, session, -1L);
    }

    private String search(String data, String type, String session, Long version) throws SecretException {
        if (StringUtils.isEmpty(data)) {
            return data;
        }
        try {
            SecretContext secretContext = this.secretCore.getSecret(session, version);
            if (secretContext == null) {
                throw new SecretException("secretKey is null");
            }
            if (secretContext.getSecret() == null) {
                return data;
            }
            String separator = SecurityBiz.getSeparatorMap().get(type);
            if (separator == null) {
                throw new SecretException("type error");
            }
            SecurityCounter.addSearchCount(type);
            if ("phone".equals(type)) {
                return SecurityBiz.searchPhoneIndex(data, separator, secretContext);
            }
            int compressLen = this.secretCore.getCompressLen();
            int slideSize = this.secretCore.getSlideSize();
            return SecurityBiz.searchNormalIndex(data, compressLen, slideSize, secretContext);
        }
        catch (ApiException e) {
            throw new SecretException(e.getErrCode(), e.getErrMsg(), e.getSubErrCode(), e.getSubErrMsg());
        }
    }

    private String encrypt(String data, String type, String session, Long version) throws SecretException {
        if (StringUtils.isEmpty(data)) {
            return data;
        }
        try {
            SecretContext secretContext = this.secretCore.getSecret(session, version);
            if (secretContext == null) {
                throw new SecretException("secretKey is null");
            }
            if (secretContext.getSecret() == null) {
                return data;
            }
            String separator = SecurityBiz.getSeparatorMap().get(type);
            if (separator == null) {
                throw new SecretException("type error");
            }
            SecurityCounter.addEncryptCount(type);
            boolean isEncryptIndex = this.secretCore.isIndexEncrypt(type, version);
            if (isEncryptIndex) {
                if ("phone".equals(type)) {
                    return SecurityBiz.encryptPhoneIndex(data, separator, secretContext);
                }
                int compressLen = this.secretCore.getCompressLen();
                int slideSize = this.secretCore.getSlideSize();
                return SecurityBiz.encryptNormalIndex(data, compressLen, slideSize, separator, secretContext);
            }
            if ("phone".equals(type)) {
                return SecurityBiz.encryptPhone(data, separator, secretContext);
            }
            return SecurityBiz.encryptNormal(data, separator, secretContext);
        }
        catch (ApiException e) {
            throw new SecretException(e.getErrCode(), e.getErrMsg(), e.getSubErrCode(), e.getSubErrMsg());
        }
    }

    public Map<String, String> encrypt(List<String> dataList, String type) throws SecretException {
        return this.encrypt(dataList, type, null);
    }

    public Map<String, String> encrypt(List<String> dataList, String type, String session) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            throw new SecretException("dataList can`t be empty");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String data : dataList) {
            if (resultMap.containsKey(data)) continue;
            String encryptValue = this.encrypt(data, type, session, null);
            resultMap.put(data, encryptValue);
        }
        return resultMap;
    }

    public static String generateCustomerSession(long userId) {
        return "_" + userId;
    }
}

